import xbmc, xbmcaddon, xbmcvfs, os, subprocess, sys

# --- New: Credentials Update Logic ---
def update_credentials():
    try:
        addon = xbmcaddon.Addon()
        user = addon.getSetting('vpn_user')
        pwd = addon.getSetting('vpn_pwd')
        
        # We use a hard path to ensure the shell script finds it
        cred_path = "/storage/.kodi/addons/service.openvpn.portable/resources/scripts/users.txt"
        
        # Ensure directory exists just in case
        os.makedirs(os.path.dirname(cred_path), exist_ok=True)
        
        with open(cred_path, 'w') as f:
            f.write(f"{user}\n{pwd}")
        
        os.chmod(cred_path, 0o600)
        xbmc.log("VPN_PORTABLE: users.txt updated successfully.", xbmc.LOGINFO)
    except Exception as e:
        xbmc.log(f"VPN_PORTABLE: Failed to update credentials: {str(e)}", xbmc.LOGERROR)

# --- New: The "Smart" Monitor ---
class VpnMonitor(xbmc.Monitor):
    def onSettingsChanged(self):
        # This triggers immediately when you click 'OK' in the settings
        xbmc.log("VPN_PORTABLE: Settings change detected!", xbmc.LOGINFO)
        update_credentials()

def cleanup():
    xbmc.log("VPN_PORTABLE: Cleaning up network rules...", xbmc.LOGINFO)
    os.system("sysctl -w net.ipv4.ip_forward=0")
    os.system("killall -9 openvpn 2>/dev/null")

def run_service():
    addon = xbmcaddon.Addon()
    # Use our new smart monitor instead of the default one
    monitor = VpnMonitor() 
    
    base_path = xbmcvfs.translatePath(addon.getAddonInfo('path'))
    res_path = os.path.join(base_path, 'resources')
    
    # Force an update on boot so the file matches the settings
    update_credentials()

    # 20s Boot Delay to let the Pi network stabilize
    if not monitor.waitForAbort(20):
        xbmc.log("VPN_PORTABLE: Service monitor waking up...", xbmc.LOGINFO)

    while not monitor.abortRequested():
        autostart = addon.getSetting('autostart_server').lower() == 'true'
        is_running = os.system("pgrep -x openvpn > /dev/null") == 0

        if autostart and not is_running:
            xbmc.log("VPN_PORTABLE: Auto-starting server...", xbmc.LOGINFO)
            os.system("sysctl -w net.ipv4.ip_forward=1")
            os.system("iptables -t nat -A POSTROUTING -s 10.8.0.0/24 -o eth0 -j MASQUERADE 2>/dev/null || iptables -t nat -A POSTROUTING -s 10.8.0.0/24 -o wlan0 -j MASQUERADE")
            
            cmd = ["/usr/bin/openvpn", "--config", "server.conf", "--log-append", "logs/openvpn.log"]
            subprocess.Popen(cmd, cwd=res_path)

        if monitor.waitForAbort(30): 
            break
            
    cleanup()

if __name__ == '__main__':
    run_service()