# SPDX-License-Identifier: GPL-2.0
import xbmcaddon
import xbmcgui
import subprocess
import re
import csv
import os.path

non_gbm = { '10.0' : [ 'Generic.x86_64' ],
            '11.0' : [ 'Generic-legacy.x86_64', 'x11.x86_64', 'wayland.x86_64' ],
           }

path = xbmcaddon.Addon().getAddonInfo('path')

script = os.path.join(path, 'bin/gbm-shell.start')

with open('/etc/os-release') as stream:
    contents = stream.read().strip()
vars = re.findall(r"^[a-zA-Z0-9_]+=.*$", contents, flags=re.MULTILINE)
reader = csv.reader(vars, delimiter="=")
osrelease = dict(reader)

version_id = osrelease['VERSION_ID']
if float(version_id) > 11.0:
  version_id = '11.0'

if 'DISTRO_ARCH' in osrelease:
  arch = osrelease['DISTRO_ARCH']
else:
  arch = osrelease['LIBREELEC_ARCH']
if arch not in non_gbm[version_id]:
  yes = xbmcgui.Dialog().yesno('GBM Shell', 'Replace Kodi with terminal?',
                               nolabel='No', yeslabel='Yes')
  if yes:
    subprocess.run(["systemd-run", script])
else:
  xbmcgui.Dialog().ok('GBM Shell', 'Canceled, not on GBM system')
