import xbmcaddon
import time

ADDON = xbmcaddon.Addon()
BRIGHTNESS_PATH = "/sys/class/backlight/rpi_backlight/brightness"

def set_brightness(value):
    try:
        with open(BRIGHTNESS_PATH, "w") as f:
            f.write(str(value))
    except Exception as e:
        print(f"[RPI Brightness] Error setting brightness: {e}")

def main():
    time.sleep(5)  # wait for system to be ready
    if ADDON.getSettingBool("apply_on_startup"):
        brightness = ADDON.getSetting("brightness")
        if brightness and brightness.isdigit():
            set_brightness(int(brightness))
        else:
            print("[RPI Brightness] No valid brightness setting found.")
    else:
        print("[RPI Brightness] Startup brightness setting disabled.")

if __name__ == "__main__":
    main()
