import xbmcaddon
import xbmcgui

ADDON = xbmcaddon.Addon()
BRIGHTNESS_PATH = "/sys/class/backlight/rpi_backlight/brightness"

def set_brightness(value):
    try:
        with open(BRIGHTNESS_PATH, "w") as f:
            f.write(str(value))
    except Exception as e:
        xbmcgui.Dialog().notification(ADDON.getLocalizedString(30004), f"{e}", xbmcgui.NOTIFICATION_ERROR)

def main():
    current_value = int(ADDON.getSetting("brightness") or "200")
    value = xbmcgui.Dialog().numeric(0, ADDON.getLocalizedString(30002), str(current_value))
    if value.isdigit():
        brightness = max(0, min(255, int(value)))
        set_brightness(brightness)
        ADDON.setSetting("brightness", str(brightness))
        xbmcgui.Dialog().notification(ADDON.getLocalizedString(30003), str(brightness), xbmcgui.NOTIFICATION_INFO)

if __name__ == "__main__":
    main()
