#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#  setAVR.py
#  
import sys
import telnetlib
import time
from datetime import datetime
import os
from os import system as system_call # Execute a shell command

def ping(host):
    # Pinging (Ping-Antwort zum NULL-Device geschickt)
    return system_call("ping -c 1 " + host + ">> /dev/null") == 0

def test_ip(host):
    mes = ""
    testbegin = str(datetime.now().time())
    j = 25
    for i in range (1,j):
        if ping(host):
            mes = "um "+str(datetime.now().time())+" wurde "+host+" erreicht" 
            break
    testend = str(datetime.now().time())
    if i == j-1:
        mes = "Von "+ testbegin[0:8]+ " bis "+testend[0:8]+ \
              " versucht "+host+" zu erreichen (vergeblich)"
    return (ping(host),mes)

########################################################################
# main
########################################################################
host = "192.168.178.28" # AVReceiver
port = "23"

with open("./autostart.log", "w") as file:
    m1 = 'Ausführung des Skripts "'+os.path.basename(__file__)+'"\n' \
         +"um "+str(datetime.now().time())+" (Skriptstart)\n"
    print (m1)
    file.write (m1)
    time.sleep(20)    
    reached, m2 = test_ip(host)
    print (m2)
    file.write (m2)
    if reached :
        t = telnetlib.Telnet() 
        t.open(host,port) 
        SendKeys = "PWON" # Receiver einschalten
        t.write(SendKeys.encode('ascii')+ b"\n")
        m3 = " AVReceiver ist eingeschaltet "
        print (m3)
        file.write (m3)
        time.sleep(1)
        SendKeys = "SIMPLAY" # Mediaplayer als Inputquelle wählen
        t.write(SendKeys.encode('ascii')+ b"\n")
        time.sleep(1)        
        m4 = " Kodi ist Receiver-Quelle "
        print (m4)
        file.write (m4)        
        t.close()
file.close()



