<?php
function endsWith($haystack, $needle) {
    return substr_compare($haystack, $needle, -strlen($needle)) === 0;
}

$foreignurl = "https://test.libreelec.tv/" ;
$thisurl = "https://up.legg.ga/";

$archs["rpi2"]["arch"] = "RPi2.arm";
$archs["rpi2"]["prettyname_regex"] = "^LibreELEC-.*-([0-9]{8}-[0-9a-f]*).*$";
$archs["rpi2"]["displayName"] = "Raspberry Pi 2 and 3";
$archs["rpi2"]["extension"] = ".tar";
$archs["rpi2"]["channelName"] = "LEnightly-9.80";

$archs["rpi4"]["arch"] = "RPi4.arm";
$archs["rpi4"]["prettyname_regex"] = "^LibreELEC-.*-([0-9]{8}-[0-9a-f]*).*$";
$archs["rpi4"]["displayName"] = "Raspberry Pi 4";
$archs["rpi4"]["extension"] = ".tar";
$archs["rpi4"]["channelName"] = "LEnightly-9.80";

if(isset($_GET["q"]) && endsWith($_GET["q"],"releases.json")){
    if(preg_match('/([^\/]+)\/releases.json/', $_GET["q"], $aar)){
        $arch_sel = $aar[1];
        if(!array_key_exists($arch_sel,$archs)){
            echo "Arch not found";
            exit;
        }
    }else{
        echo "Arch not specified";
        exit;
    }
    
    $thisurl = $thisurl.$arch_sel."/";
    $arch = $archs[$arch_sel];

    $site = file_get_contents($foreignurl);

    $pattern = '/<a href="(LibreELEC-([^-]+)-([\d\.]+)[^"]+-([0-9a-f]{7}).tar)">[^<]+<\/a><\/td><td\s*class="indexcollastmod">(\d+-\d+-\d+)\s*(\d+:\d+)\s*<\/td><td\s*class="indexcolsize">(\d+)M/';
    if(preg_match_all($pattern, $site, $files, PREG_SET_ORDER)){
        header('Content-Type: application/json');
        $res[$arch["channelName"]]["prettyname_regex"] = $arch["prettyname_regex"];
        $res[$arch["channelName"]]["prettyname_separators"] = array();
        $res[$arch["channelName"]]["project"][$arch["arch"]]["displayName"] = $arch["displayName"];
        $res[$arch["channelName"]]["url"] = $thisurl;
        $res[$arch["channelName"]]["project"][$arch["arch"]]["url"] = $thisurl;
        

        $releases = new stdClass;
        $count=1;
        foreach($files as $file){
            if($file[2] != $arch["arch"]){
                //echo "<b>invalid arch</b><br/>";
                continue;
            }
            if(!endsWith($file[1],$arch["extension"])){
                //echo "<b>invalid filetype</b><br/>";
                continue;
            }
            $datei = array("name" =>  $file[1], "size" => strval($file[7] * 1024 * 1024));
            $releases->{$count}->file = $datei;

            $count = $count+1;
            
        }
        
        $res[$arch["channelName"]]["project"][$arch["arch"]]["releases"] = (array) $releases;
        
        echo json_encode($res, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    }
}elseif(isset($_GET["q"]) && endsWith($_GET["q"],".tar")){
    if(preg_match('/([^\/]+\.tar)/', $_GET["q"], $file)){
        $arch_sel = $file[1];
        header('Location: '.$foreignurl.$file[1]);
    }else{
        echo "file not match";
    }
    exit;
}else{
    echo "<h1>The following architectures exist:</h1><br/>";
    foreach(array_keys($archs) as $arch){
        echo "<b>Arch: ".$arch."</b><br/>";
        echo "Name: ".$archs[$arch]["displayName"]."<br/>";
        echo "Update URL: ".$thisurl.$arch."/<br/>";
        echo "Releases: <a href=\"".$arch."/releases.json\">releases.json</a><br/><br/>";
    }
}
?>
