#! /usr/bin/python
import socket
import struct
import sys
import time
 
#multicast_group = '232.0.10.146'
multicast_group = '232.0.20.35'
ssm_address = '87.141.215.251'
# if needed the IP-address of a specific local interface
# to receive the broadcast can be defined here:
local_address = '0.0.0.0'
port = 10000
 
group = socket.inet_aton(multicast_group)
ssm = socket.inet_aton(ssm_address)
local = socket.inet_aton(local_address)

print(sys.platform)

if sys.platform.startswith('win32'):
    if not hasattr(socket, 'IP_ADD_SOURCE_MEMBERSHIP'):
        setattr(socket, 'IP_ADD_SOURCE_MEMBERSHIP', 15)
    mreq = struct.pack('4s4s4s', group, ssm, local)
elif sys.platform.startswith('linux'):
    if not hasattr(socket, 'IP_ADD_SOURCE_MEMBERSHIP'):
        setattr(socket, 'IP_ADD_SOURCE_MEMBERSHIP', 39)
    mreq = struct.pack('4s4s4s', group, local, ssm)
 
# Create the socket
print ("Create socket:")
print ("  In Wireshark (e.g. with filter 'igmp') or tcpdump (tcpdump igmp -vv) you should now see the joining of the multicast group with new source")
sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM, socket.IPPROTO_UDP)
sock.bind((local_address, port))
sock.setsockopt(socket.IPPROTO_IP, socket.IP_ADD_SOURCE_MEMBERSHIP, mreq)

#data, address = sock.recvfrom(10240)
time.sleep(2)
sock.close()
print ("Close socket:")
print ("  In Wireshark or tcpdump you should now see the blocking of the source address")
