import time
import xbmc
import xbmcaddon
import xbmcgui
import sys
sys.path.append('/storage/.kodi/addons/virtual.rpi-tools/lib')
import RPi.GPIO as GPIO



sd_counter = 0
scriptid = "script.service.ampcontrol"
scriptname = "Amplifier Control"
Addon = xbmcaddon.Addon(scriptid)
timeout = Addon.getSettingInt("limit")
pin = int(Addon.getSetting("gpio_pin"))
notes = Addon.getSetting("notification")
power = False
notify = xbmcgui.Dialog()


def setup():
	GPIO.setmode(GPIO.BCM)
	GPIO.setup(pin, GPIO.OUT)
	GPIO.setwarnings(False)
	return()
def turn_on():
	GPIO.output(pin,True)
	return()
def turn_off():
	GPIO.output(pin,False)
	return()

xbmc.log("ADDON:script.service.ampcontrol: GPIO pin is set to %s" % pin, level=xbmc.LOGNOTICE)
xbmc.log("ADDON:script.service.ampcontrol: Timeout is set to %s minutes" % timeout, level=xbmc.LOGNOTICE)
try:
	setup()
except:
	notify.notification("Amplifier Control","Something wrong")

if __name__ == '__main__':
	monitor = xbmc.Monitor()
	player = xbmc.Player()
	while not monitor.abortRequested():
		# Sleep/wait for abort for 10 seconds
		if monitor.waitForAbort(2):
			# Abort was requested while waiting. We should exit
			break
		
		if player.isPlaying():
			if not power:
				if sd_counter != 0:
					turn_on()
                    power = True
					sd_counter = 0
					if notify:
						notify.notification("Amplifier Control","Turning ON")
				
		else:
			if sd_counter < timeout*30:
				sd_counter += 1
			elif sd_counter == timeout*30:
				turn_off()
                power = False
				if notify:
					notify.notification("Amplifier Control","Turning OFF")
				sd_counter += 1