# -*- coding: utf-8 -*-

'''
    AccuRadio Audio Addon
    Copyright (C) 2016 Hamid_PaK

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

from resources.lib.kodious import kodious
from resources.lib.modules.accuRadioBase import accuRadioBase


class accuRadioModule(accuRadioBase):

    @kodious.route('/', {'default': True})
    def accuRadioIndex(self):

        # Indexes the main items
        # 
        # Play Now
        self.view.addRouteItem({ 'route': 'accuRadio.SurpriseMe' }, 30010,
            artValues={
                'icon': self.media.icon('playnow'),
                'fanart': self.media.image('fanart'),
            })
        # Browse Genres
        self.view.addRouteDirItem({ 'route': 'accuRadio.IndexGenres' }, 30016,
            artValues={
                'icon': self.media.icon('browsegenres'),
                'fanart': self.media.image('fanart'),
            })
        # Favorite Channels
        self.view.addRouteDirItem({ 'route': 'accuRadio.FavouriteChannels' }, 30018,
            artValues={
                'icon': self.media.icon('favouritechannels'),
                'fanart': self.media.image('fanart'),
            })
        # Played History
        # self.view.addRouteDirItem({ 'route': 'accuRadio.PlayedHistory' }, 30019,
        #     artValues={
        #         'fanart': self.media.image('fanart')
        #     })
        # Settings
        self.view.addRouteItem({ 'route': 'accuRadio.OpenSettings' }, 30020,
            artValues={
                'icon': self.media.icon('settings'),
                'fanart': self.media.image('fanart')
            })

        # Renders all the current list items in this view
        self.view.render()


    @kodious.route('/accuRadio.SurpriseMe/')
    def accuRadioSurpriseMe(self):

        # Gets most popular channels
        channels = self.getChannels('feat/mostpopular', True)

        if channels and len(channels):
            import random

            # Gets a random channel
            channel = random.choice( channels )

            # Redirects to player
            self.redirect({
                'route': 'accuRadio.PlayChannel',
                'channelID': channel['id']
            })


    @kodious.route('/accuRadio.IndexGenres/')
    def accuRadioIndexGenres(self):

        # Gets all the genres
        genres = self.getGenres()

        # Indexes all the genres
        if genres and isinstance(genres, list):
            for genre in genres:
                self.view.addRouteDirItem({
                    'route': 'accuRadio.IndexChannels',
                    'genreID': genre['id'],
                    'genreTitle': genre['title'],

                }, genre['title'],
                artValues={
                    'icon': self.media.icon('browsechannels'),
                    'fanart': self.media.image('fanart'),
                })

            self.view.render()

        else:
            self.view.render(succeeded=False, cacheToDisc=False)


    @kodious.route('/accuRadio.IndexChannels/:genreID/:genreTitle/')
    def accuRadioIndexChannels(self, genreID, genreTitle):

        # Gets all the channels of the genre
        channels = self.getChannels( genreID )

        # Indexed all the cahnnels
        if channels and isinstance(channels, list) and len(channels):
            for channel in channels:
                print channel['cover']
                item = self.view.addRouteItem({
                    'route': 'accuRadio.PlayChannel',
                    'channelID': channel['id'],
                    'genreTitle': genreTitle,

                }, channel['title'],
                # These are the kwargs for the ListItem
                artValues={
                    'thumb': channel['cover'],
                    'fanart': self.media.image('fanart'),
                })

                # Adds the context menus
                item.addContextMenuItems([( self.language.get( 30200 ), self.getRouteRun({
                    'route': 'accuRadio.AddFavouriteChannel',
                    'channelID': channel['id'],
                    'channelTitle': channel['title'].encode('utf-8'),
                }) )], True)

            self.view.content('files')
            self.view.render()

        else:
            self.view.render(succeeded=False, cacheToDisc=False)


    @kodious.route('/accuRadio.FavouriteChannels/')
    def accuRadioUserFavouriteChannels(self):

        if not self.userGetCredentials():
            self.view.dialog.ok( self.language.get( 30164 ))

            return

        if not self.userIsLoggedIn():
            self.view.dialog.ok( self.language.get( 30166 ))
            self.view.render(succeeded=False)

            return

        # Gets all the favourite channels of current user
        channels = self.userGetFavouriteChannels()

        # Indexed all the cahnnels
        if channels and isinstance(channels, list) and len(channels):
            for channel in channels:
                item = self.view.addRouteItem({
                    'route': 'accuRadio.PlayChannel',
                    'channelID': channel['id'],
                    # 'genreTitle': genreTitle,

                }, channel['title'],
                # These are the kwargs for the ListItem
                artValues={
                    'thumb': channel['cover'],
                })

                # Adds the context items to this list item
                item.addContextMenuItems([( self.language.get( 30201 ), self.getRouteRun({
                    'route': 'accuRadio.RemoveFavouriteChannel',
                    'channelID': channel['id'],
                }) )], True)

            self.view.render()

        else:
            self.view.render(succeeded=False, cacheToDisc=False)


    @kodious.route('/accuRadio.AddFavouriteChannel/:channelID/:channelTitle/')
    def accuRadioUserAddFavouriteChannel(self, channelID, channelTitle):
        if self.userAddFavouriteChannel( channelID, channelTitle ):
            # Shows the successful message
            self.view.dialog.ok( self.language.get( 30220 ) )
        else:
            # Shows the error message
            self.view.dialog.ok( self.language.get( 30210 ) )


    @kodious.route('/accuRadio.RemoveFavouriteChannel/:channelID/')
    def accuRadioUserRemoveFavouriteChannel(self, channelID):
        if self.removeUserFavouriteChannel( channelID ):
            # Shows the successful message
            self.view.dialog.ok( self.language.get( 30221 ) )
            self.view.refresh()
        else:
            # Shows the error message
            self.view.dialog.ok( self.language.get( 30210 ) )


    @kodious.route('/accuRadio.IndexHistoryChannel/')
    def accuRadioUserHistoryChannels(self):
        # Checks if credentials are available
        if not self.getUserCredentials():
            self.view.dialog.ok( self.language.get( 30164 ))

            return

        # Checks if user is NOT logged-in, shows an error message
        if not self.isLoggedIn():
            self.view.dialog.ok( self.language.get( 30166 ))
            self.view.render(succeeded=False)

            return

        # Gets all the favourite channels of current user
        channels = self.getUserHistoryChannels()

        # Indexed all the cahnnels
        if channels and isinstance(channels, list) and len(channels):
            for channel in channels:
                item = self.view.addRouteItem({
                    'route': 'accuRadio.PlayChannel',
                    'channelID': channel['id'],
                    # 'genreTitle': genreTitle,

                }, channel['title'],
                # These are the kwargs for the ListItem
                artValues={
                    'thumb': channel['cover'],
                })

                # Add the context items to this list item
                item.addContextMenuItems([( self.language.get( 30201 ), self.getRouteRun({
                    'route': 'accuRadio.RemoveFavouriteChannel',
                    'channelID': channel['id'],
                }) )], True) # Add to favourites 

            self.view.render()

        else:
            self.view.render(succeeded=False, cacheToDisc=False)


    @kodious.route('/accuRadio.OpenSettings/')
    def accuRadioOpenSettings(self):
        # Runs the settings dialog
        self.openSettings()


    @kodious.route('/accuRadio.ClearCache/')
    def accuRadioClearCache(self):
        if self.view.dialog.yesno( self.language.get( 30140 ), autoClose=10000): # Are you sure?
            self.cache.flush()
            self.view.dialog.ok( self.language.get( 30600 ) )    # Action is done


