# -*- coding: utf-8 -*-

'''
    Kodious
    Copyright (C) 2016 Hamid_PaK

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

from xml.dom import Node
from xml.dom import minidom


class XML2DICT(object):
    def __parseNode(self, node, result):
        if not node.hasChildNodes():
            if node.nodeType == node.ELEMENT_NODE:
                element = { 'childs': [] }

                if hasattr(node, 'hasAttributes') and node.hasAttributes():
                    attributes = dict([(str(attr), str(node.attributes[attr].value)) for attr in node.attributes.keys()])
                    element.update({ 'attributes': attributes })

                return { node.nodeName: element }

            elif node.nodeType == node.TEXT_NODE:
                if node.nodeValue.strip() != '':
                    return node.nodeValue
        else:
            childs = [x for x in [self.__parseNode(child, {}) for child in node.childNodes if child.nodeType != Node.COMMENT_NODE] if x != None]

            element = { 'childs': childs }
            if hasattr(node, 'hasAttributes') and node.hasAttributes():
                attributes = dict([(str(attr), str(node.attributes[attr].value)) for attr in node.attributes.keys()])
                element.update({ 'attributes': attributes })

            result.update({ node.nodeName: element })

            return result

        return


    def loadXml(self, filepath=None):
        self._xmlFilepath = filepath
        self._xml = minidom.parse( filepath )
        return self


    def parseXml(self):
        self._dict = self.__parseNode(self._xml, {})
        return self


    def select(self, selector, obj=False):
        key = selector.get('tag', None)
        attr = selector.get('attr', None)

        # print 'Selector: %s, object: %s' % (selector, str( obj )[:40])

        if obj == False:
            obj = [self._dict]

        result = []
        if isinstance(obj, list):
            for item in obj:
                x = self.select(selector, item)
                if x: result.extend( x )

        elif isinstance(obj, dict):
            for k, item in obj.iteritems():
                # print 'Key %s, selected: %s' % (k, key)

                if (key == k):
                    if (attr):

                        attrName = attr.get('name', None)
                        attrValue = attr.get('value', None)
                        attributes = item.get('attributes', {})


                        if (attrName and attrName in attributes.keys()):

                            if (not attrValue):
                                result.append({ k: item })
                            elif (unicode( attrValue ).lower() == unicode( attributes.get(attrName, '')).lower() and attributes.get(attrName) != None):
                                result.append({ k: item })
                    else:
                        result.append({ k: item })

                x = self.select(selector, item['childs'])
                if x: result.extend( x )

        elif isinstance(obj, basestring):
            return result.append( obj )

        return result


    def find(self, selectors=[{}], obj=False):
        result = None
        if not isinstance(selectors, list):
            selectors = [selectors]

        for selector in selectors:
            result = self.select(selector, obj)
            if result: obj = result

        return result

