# -*- coding: utf-8 -*-

'''
    Kodious
    Copyright (C) 2016 Hamid_PaK

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import os

from os import path as plib


class AddonModuleMedia(object):

    def __init__(self, parent):
        object.__init__(self)

        self._parent = parent
        self._unknown_icon = None
        self._unknown_image = None
        self._allowed_exts = [ '.jpeg', '.jpg', '.png' ]


    def __listDir(self, current_path):
        if plib.isdir( current_path ):
            for item in os.listdir( current_path ):

                item_abs_path = plib.join( current_path, item )
                if plib.isdir( item_abs_path ):
                    self.__listDir( item_abs_path )
                    continue

                for ext in self._allowed_exts:
                    if item.endswith( ext ):
                        self._files.append( item_abs_path.replace( self._path, '' ).lstrip( plib.sep ))


    def setUnknownImage(self, filename):
        self._unknown_image = filename


    def setUnknownIcon(self, filename):
        self._unknown_icon = filename


    def setAllowedExts(self, ext_list):
        if isinstance(ext_list, list):
            self._allowed_exts = ext_list


    def setMediaPath(self, path):
        if plib.isabs( path ):
            self._path = path

            self._files = []
            self.__listDir( self._path )
            self._files = sorted(self._files, key=lambda k: len(k))

        else:
            KodiousException('AddonModuleMedia::setMediaPath => set media path parameter should be absolute!').handle()


    def find(self, partial):
        for file in self._files:
            try:
                if not isinstance(partial, list):
                    partial = [ partial ]

                for part in partial:
                    file.index( part )

                return plib.join( self._path, file )
            except: continue


    def image(self, filename):
        fullpath = self.find( filename )

        if not fullpath and self._unknown_image:
            fullpath = self._unknown_image

        return fullpath


    def icon(self, filename):
        fullpath = self.find([ 'icon', filename ])

        if not fullpath and self._unknown_icon:
            fullpath = self._unknown_icon

        return fullpath
