# -*- coding: utf-8 -*-

'''
    Kodious
    Copyright (C) 2016 Hamid_PaK

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import os
import re
import sys
import hashlib
import urlparse
import base64 as b64
import json as json_lib

from kodi import xbmc
from kodi import xbmcaddon
from kodi import xbmcplugin

from cachable import Cachable
from view import AddonModuleView
from media import AddonModuleMedia
from client import HttpClient, Url
from language import AddonModuleLanguage


class AddonModule(object):
    def __init__(self, _path=None, _id=None, _name=None, _version=None, _type=None, _author=None):
        object.__init__(self)

        self._addon = xbmcaddon.Addon()
        self._properties = {}

        self.getAddonInfo = info = self._addon.getAddonInfo
        self.getSetting = self._addon.getSetting
        self.setSetting = self._addon.setSetting
        self.openSettings = self._addon.openSettings

        try: self._id = _id or info('id')
        except: self._id = None

        try: self._name = _name or info('name')
        except: self._name = None

        try: self._version = _version or info('version')
        except: self._version = None

        try: self._author = _author or info('author')
        except: self._author = None

        try: self._type = _type or info('type')
        except: self._type = None

        self._path = info('path')
        self._dataPath = xbmc.translatePath( info('profile') )

        try: self._handle = int(sys.argv[1])
        except: self._handle = -1

        try: self._system_url = sys.argv[0]
        except: self._system_url = 'plugin://' + self._id

        # Instantiates the module langauge
        self.language = AddonModuleLanguage( self )

        # Instantiates the module http client
        self.http = HttpClient( os.path.join( self.getDataPath(), 'http_client.cookie' ))

        # Instantiates the module cache
        self.cache = Cachable( self.getDataPath() )

        # Instantiates the module view
        self.view = AddonModuleView( self )

        # Instantaites the module media control
        self.media = AddonModuleMedia( self )
        self.media.setMediaPath( os.path.join( self._path, 'resources', 'media' ))

        if os.path.isfile( os.path.join( self._path, 'icon.png' )):
            self.media.setUnknownIcon( os.path.join( self._path, 'icon.png' ))

        if os.path.isfile( os.path.join( self._path, 'fanart.jpg' )):
            self.media.setUnknownImage( os.path.join( self._path, 'fanart.jpg' ))


    def setID(self, _id):
        self._id = _id


    def setVersion(self, _version):
        self._version = _version


    def setName(self, _name):
        self._name = _name


    def setAuthor(self, _author):
        self._author = _author


    def getID(self):
        return self._id


    def getVersion(self):
        return self._version


    def getName(self):
        return self._name


    def getAuthor(self):
        return self._author


    def getDataPath(self):
        return self._dataPath


    def setCategory(self, category):
        '''
        Sets the module name for skins to display.

        Parameters:
            category    string or unicode - plugins sub category.
        '''
        xbmcplugin.setPluginCategory(self._handle, category)


    def setProperty(self, key, value):
        '''
        Sets a container property for this plugin.

        Parameters:
            key string - property name.
            value   string or unicode - value of property.
        Note:
            Key is NOT case sensitive.
        '''
        self._properties.update({ key: value })
        xbmcplugin.setProperty(self._handle, key, value)


    def setFanart(self, image, color1='', color2='', color3=''):
        '''
        Sets the module fanart and color for skins to display.

        Parameters:
            handle  integer - handle the plugin was started with.
            image   [opt] string - path to fanart image.
            color1  [opt] hexstring - color1. (e.g. '0xFFFFFFFF')
            color2  [opt] hexstring - color2. (e.g. '0xFFFF3300')
            color3  [opt] hexstring - color3. (e.g. '0xFF000000')
        '''
        xbmcplugin.setPluginFanart(self._handle, image, color1, color2, color3)


    def getFanart(self):
        fanart_image = os.path.join( self._path, 'fanart.jpg' )

        # Checks image exists
        if os.path.isfile( fanart_image ):
            return fanart_image

        return None


    def redirect(self, routeParams):
        self.execBuiltin( self.getRouteRun( routeParams ))


    def getRouteRun(self, routeParams):
        return 'RunPlugin(%s)' % Url(self._system_url, query=routeParams).getUrl()


    def execBuiltin(self, function):
        if not isinstance(function, basestring):
            function = str( function )

        xbmc.executebuiltin( function )


    def sleep(self, time):
        xbmc.sleep( time )


    def log(self, *args, **kwargs):
        if ('return' in kwargs) and (kwargs['return'] == True):
            result = ''
            for x in args:
                result += str( x ) + '\n'
                return result

        else:
            xbmc.log('--------------------------------[ %s ]--------------------------------' % self._name, kwargs.get('level', 2))
            for x in args:
                xbmc.log(str( x ), kwargs.get('level', 2))


    def execJSON(self, value):
        try:
            result = xbmc.executeJSONRPC( value )

            return json_lib.loads( result )
        except:
            return


    def resolveItem(self, item, succeeded=True):
        xbmcplugin.setResolvedUrl(self._handle, succeeded, item.getListItem())


    def getSecretInt(self, string_key):
        result = hashlib.md5()
        result.update( string_key )
        return int( re.sub('[^\d]', '', result.hexdigest())[-3:] )


    def encryptB64(self, obj, key=None):
        if key:
            secret = self.getSecretInt( key )
            obj = self.simpleEncrypt( secret, obj )

        return b64.encodestring(obj).strip()


    def decryptB64(self, obj, key=None):
        obj = b64.decodestring(obj)

        if key:
            secret = self.getSecretInt(key)
            obj = self.simpleDecrypt( secret, obj )

        return obj


    def simpleEncrypt(self, secret_int, obj):
        result = ''

        if not isinstance(obj, basestring):
            print obj
            obj = json_lib.dumps(obj)

            print obj

        for each in str( unicode( obj ).encode('utf-8') ):
            c = (ord(each) + secret_int) % 126

            if c < 32:
                c += 31

            result += chr(c)

        return result


    def simpleDecrypt(self, secret_int, obj):
        result = ''

        for each in obj:
            p = (ord(each) - secret_int) % 126

            if p < 32:
                p += 95

            result += chr(p)

        try:
            result = json_lib.loads(result)
        except: pass

        return result
