# -*- coding: utf-8 -*-

'''
    Kodious
    Copyright (C) 2016 Hamid_PaK

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import types


def returnString(variable):
    result = ''
    if isinstance(variable, tuple):
        # print 'tuple: ', variable
        result += '(%s), ' % returnArrayString( variable )

    elif isinstance(variable, list):
        # print 'array: ', variable
        result += 'list{%s}, ' % returnArrayString( variable )#.rstrip(', ')

    elif isinstance(variable, dict):
        # print 'dict: ', variable
        result += 'dict{%s}, ' % returnDictString( variable )

    else:
        result += '"%s", ' % (str( variable ))

    return result


def returnArrayString(array):
    result = ''
    for x in array:
        result += returnString( x )

    return result


def returnDictString(dictionary):
    result = ''
    for key, value in dictionary.iteritems():
        result += '%s: %s ' % (key, returnString( value ))

    return result


def ClassWrapper(baseClass, className):
    class GenericClass():
        def __init__(self, *args, **kwargs):
            self._name = className
            self._class = baseClass
            try:
                self._instance = baseClass(*args, **kwargs)
            except TypeError:
                self._instance = baseClass()

        def __getattr__(self, name):
            try:
                return getattr(self._instance, name)
            except AttributeError:
                def exposer(*args, **kwargs):
                    print '========[ %s ]========' % className

                    passArgs = ()
                    if len(args):
                        passArgs += args

                    if len(kwargs):
                        passArgs += tuple(kwargs.iteritems())

                    print '%s => %s' % (name, returnString( passArgs ))
                    print ''

                return exposer

    return GenericClass


class ModuleWrapper(types.ModuleType):
    def __init__(self, baseClass, className):
        self._name = className
        self._class = baseClass

    def __getattr__(self, name):
        try:
            return getattr(self._class, name)
        except AttributeError:
            def exposer(*args, **kwargs):
                print '========[ %s ]========' % self._name

                passArgs = ()
                if len(args):
                    passArgs += args

                if len(kwargs):
                    passArgs += tuple(kwargs.iteritems())

                print '%s => %s' % (name, returnString( passArgs ))
                print ''

            return exposer


    def __call__(self):
        return self