# -*- coding: utf-8 -*-

'''
    Kodious
    Copyright (C) 2016 Hamid_PaK

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import urllib
import urlparse


class Url(object):
    def __init__(self, base=None, path=None, query=None):
        '''
        Builds a URL

        Parameters:
            base   string or unicode    - Includes Scheme and Authority such as http://domain.com
            path   string or unicode    - The path such as /check/the/path/of/this
            query  dictionary           - pairs of { key: value }

        Example:
            Url('http://domain.com', '/this/is/path', {'query_key': 'query_value'})
        '''

        object.__init__(self)

        self._base = base
        self._path = path
        self._query = query

        
    def parse(self, url, scheme=''):
        if not url.lower().startswith('http:'):
            url = 'http:' + url

        parts = urlparse.urlparse(url, scheme, False)

        self._base = '{u.scheme}://{u.netloc}'.format(u=parts)
        self._path = parts.path
        self._query = dict( urlparse.parse_qsl( parts.query ))

        return self


    def getUrl(self):
        url = urlparse.urljoin(self._base, self._path, False)
        if isinstance( self._query, dict ) and len( self._query ):
            url += '?' + urllib.urlencode( self._query )

        return url

