# -*- coding: utf-8 -*-

'''
    Kodious
    Copyright (C) 2016 Hamid_PaK

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import os
import re
import sys
import gzip
import types
import socket
import urllib
import urllib2
import urlparse
import cookielib
import json as json_lib

from StringIO import StringIO
from html_parser import HTMLParserEx, cssSelector


class ErrorHandler(urllib2.HTTPDefaultErrorHandler):
    def http_error_default(self, req, fp, code, msg, hdrs):
        fp._msg = msg
        fp._full_url = req.get_full_url()
        return fp


class HttpResponse(object):
    def __init__(self, fp):

        object.__init__(self)

        self._root_element = None

        try: self.url = fp.geturl()
        except AttributeError: self.url = ''

        try: self.status = fp._msg
        except AttributeError: self.status = 'OK'

        try: self.status_code = fp.getcode()
        except AttributeError: self.status_code = -1000

        try: self._parseHeaders(fp.headers)
        except AttributeError: self._headers = {}

        try:
            self._content = fp.read()
            self._decompress()
        except AttributeError: self._content = ''

        self.__re_metatag = re.compile(r'<meta\s+([^\>]+)', flags=re.IGNORECASE)
        self.__re_contenttype = re.compile(r'charset=[\'"]?(\w[^\'"]+)', flags=re.IGNORECASE)
        pass

    def __del__(self):
        del self._content

    def __enter__(self):
        return self

    def __exit__(self, type, value, traceback):
        pass

    def _parseHeaders(self, hdrs):
        self._headers = {}
        for key, value in hdrs.items():
            self._headers[ key.lower() ] = value

    def _decompress(self):
        if self._headers.get('content-encoding', '').startswith('gzip'):
            buf = StringIO(self._content)
            f = gzip.GzipFile(fileobj=buf)
            self._content = f.read()
            del f
            del buf

        return

    def _charset(self):
        import traceback
        try:
            content_type = self._headers.get('content-type')

            if (content_type):
                charset_match = self.__re_contenttype.search( content_type )
                if (charset_match):
                    return charset_match.group(1)

            match = self.__re_metatag.search( self._content )
            if match:
                charset_match = self.__re_contenttype.search( match.group(1) )
                if (charset_match):
                    return charset_match.group(1)
        except: pass
        return 'ISO-8859-1'

    def _decode(self, charset=None):
        try:
            return unicode( str( self._content ).decode( charset or self._charset() ))
        except:
            return self._content

    def isOkay(self):
        return self.status_code == 200

    def getRootElement(self):
        return self._root_element

    def getHeaders(self):
        return self._headers

    def getEncoding(self):
        return

    def html(self, encodingCharset=None):
        return self._decode(encodingCharset)

    def htmlParse(self):
        # html parser
        parser = HTMLParserEx()
        parser.feed( self.html() )
        self._root_element = parser.close()
        return self

    def htmlSelect(self, selector, rootElement=None):

        if (not rootElement) and (not self._root_element):
            raise AttributeError('Elements property is empty, you might have to run "htmlParse" first!')

        # css selector
        css = cssSelector( rootElement or self._root_element )
        if not isinstance(selector, list):
            selector = [str( selector )]

        for term in selector:
            css.find(term)

        if len(css.selected):
            return css.selected
        else:
            return

    def json(self):
        try:
            return json_lib.loads(self._content)
        except:
            return
        pass



class HttpClient(object):
    def __init__(self, cookieFilepath=None):
        object.__init__(self)

        # load the cookie file
        self._cookie = cookielib.LWPCookieJar()
        if cookieFilepath:
            self.setCookieFile(cookieFilepath)

    def __del__(self):
        try:
            self._cookie.save()
        except: pass

    def _request(self, method, url, query=None, data=None, headers=None, auth=None, timeout=None, allow_redirects=True):

        if not headers:
            headers = {}

        url = urllib.quote(url, safe="%/:=&?~#+!$,;'@()*[]")

        handlers = []
        handlers.append( urllib2.HTTPCookieProcessor( self._cookie ))
        handlers.append( ErrorHandler() )

        opener = None
        opened = None
        request = None
        response = None
        try:
            opener = urllib2.build_opener(*handlers)
            request = urllib2.Request( url )

            if data:
                if isinstance(data, dict):
                    if headers.get('Content-Type', '').lower().startswith('application/json'):
                        data = json_lib.dumps( data )
                    else:
                        data = urllib.urlencode( data )
                        if not headers.get('Content-Type'):
                            headers['Content-Type'] = 'application/x-www-form-urlencoded'
                else:
                    if not isinstance(data, basestring):
                        data = str( data )

                    if isinstance(data, str):
                        data = data.encode('utf-8')

                request.data = data

            for key, value in headers.iteritems():
                try: value = str( unicode( value ).encode( 'utf-8' ))
                except: pass
                request.add_header(key, value)

            try:
                timeout = 1
                opened = opener.open( request, timeout=timeout )
            except Exception as e:
                opened = types.ClassType('TemporaryClass', (), {})
                if isinstance(e.reason, socket.timeout):
                    opened._msg = 'url error %s' % e.reason or e

            response = HttpResponse(opened)
        finally:
            del opened
            del opener
            del request
            del headers
            del handlers

        return response

    def setCookieFile(self, filepath):
        try:
            self._cookie.filename = filepath
            self._cookie.load()
        except: pass

    def get(self, url, **kwargs):
        return self._request('GET', url, **kwargs)

    def post(self, url, postData=None, **kwargs):
        return self._request('POST', url, data=postData, **kwargs)

    def request(self, url, postData=None, **kwargs):
        return self._request('POST', url, data=postData, **kwargs)
