# -*- coding: utf-8 -*-

'''
    AccuRadio Audio Addon
    Copyright (C) 2016 Hamid_PaK

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import re
import traceback

from accuRadioBase import accuRadioBase
from resources.lib.kodious import kodious
from resources.lib.kodious.kodi import xbmc
from resources.lib.kodious.listitem import MusicListItem


class accuRadioPlayer(xbmc.Player, accuRadioBase):
    def __init__(self):
        xbmc.Player.__init__(self)
        accuRadioBase.__init__(self)

        self._re_except_digits = re.compile('(\d+)')

        self.stop()
        self.sleep(500)
        self.playing = False


    @kodious.route('/accuRadio.PlayChannel/:genreTitle/:channelID')
    def accuRadioPlayChannel(self, genreTitle, channelID):
        self.channelID = channelID
        self.genreTitle = genreTitle

        self.fillPlaylist()
        self.playPlaylist()

        while self.isPlaying():
            self.sleep(500)

        self.clearPlaylist()
        # self.log('End of playing')


    def onPlayBackEnded(self):
        self.fillPlaylist()
        self.playPlaylist()


    def onPlayBackStopped(self):
        self.playing = False


    def onPlayBackStarted(self):
        self.sleep(100)

        self.updateTrackHistory()


    def updateTrackHistory(self):
        item = self.getCurrentPlayingItem()

        if item:
            self.trackHistory( item['oid'], item['cid'] )


    def getTrackYear(self, year):
        try:
            return int( self._re_except_digits.search(year.strip()).group(1) )
        except AttributeError:
            return


    def fillPlaylist(self):
        self.channelPL = self.getChannelPlaylist( self.channelID )

        if isinstance(self.channelPL, dict):
            self.playlist = xbmc.PlayList(0)
            self.playlist.clear()

            for oid, x in self.channelPL.iteritems():
                kwargs = {
                    'label': x['title'],
                    'infoType': 'music',
                    'infoValues': {
                        'title': x['title'],
                        'year': self.getTrackYear(x['album']['year']),
                        'album': x['album']['title'],
                        'artist': x['artist'],
                        'duration': x['duration'],
                        # 'discnumber': 1,
                        # 'tracknumber': 1,
                        'genre': self.genreTitle,
                    },
                    'artValues': {
                        'thumb': x['album']['cdcover'],
                    }
                }
                item = MusicListItem(**kwargs)
                self.playlist.add( x['urls'][0], item.getListItem() )


    def clearPlaylist(self):
        try:
            self.playlist.clear()
        except KeyError: pass


    def playPlaylist(self):
        self.playing = True
        self.play( self.playlist )


    def isPlaying(self):
        return self.playing


    def getCurrentPlayingItem(self):
        result = self.execJSON( '{"jsonrpc": "2.0", "method": "Player.GetActivePlayers", "id": 1}' )

        assert isinstance(result, dict)
        assert not result.get('error')

        playerID = None
        for player in result['result']:
            if player.get('type') == 'audio':
                playerID = player.get('playerid')
                # self.log('Found the player ID: %s' % playerID)
                break

        if playerID == None: return

        result = self.execJSON( '{"jsonrpc": "2.0", "method": "Player.GetItem", "params": { "properties": ["title", "file"], "playerid": %s }, "id": "AudioGetItem"}' % playerID )

        assert isinstance(result, dict)
        assert not result.get('error')
        assert result.get('result')

        current_item = result['result']['item']

        assert current_item.get('file') != None

        for oid, item in self.channelPL.iteritems():
            if current_item['file'] == item['urls'][0]:
                return item

