# -*- coding: utf-8 -*-

'''
    Kodious
    Copyright (C) 2016 Hamid_PaK

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

from kodi import xbmc
from kodi import xbmcgui


class AddonModuleViewDialog(object):
    def __init__(self, parent):
        self._dialog = xbmcgui.Dialog()
        self._addonName = parent._addonName
        self._addonHandle = parent._addonHandle
        self._addonSystemURL = parent._addonSystemURL


    def ok(self, lines, heading=None):
        '''
        Shows a dialog 'OK'
 
        Parameters:
            lines : string or unicode - multi-line text.
            heading : string or unicode - dialog heading (optional).
         
        Returns True if 'Ok' was pressed, else False.
        '''
        if not heading:
            heading = self._addonName

        self._dialog.ok( heading, lines )


    def yesno(self, lines, heading=None, noLabel=None, yesLabel=None, autoClose=None):
        '''
        Show a dialog 'YES/NO'.
 
        Parameters:
            lines : string or unicode - multi-line text.
            heading : string or unicode - dialog heading.
            nolabel : [opt] label to put on the no button.
            yeslabel : [opt] label to put on the yes button.
            autoclose : [opt] integer - milliseconds to autoclose dialog. (default=do not autoclose)

        *Note, Returns True if 'Yes' was pressed, else False.

        Example:
           dialog.yesno('Do you want to exit this script?', 'Kodi')
        '''

        if not heading:
            heading = self._addonName

        kwargs = {
            'line1': lines,
            'heading': heading
        }

        if noLabel:
            kwargs['nolabel'] = noLabel

        if yesLabel:
            kwargs['yeslabel'] = yesLabel

        if autoClose:
            kwargs['autoclose'] = autoClose

        return self._dialog.yesno(**kwargs)