# -*- coding: utf-8 -*-

'''
    Kodious
    Copyright (C) 2016 Hamid_PaK

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import os
import sys
import urllib


class RouteAction(object):
    def __init__(self, id=None):
        self.id = id or ''
        self.paths = []
        self.moduleName = ''
        self.methodName = ''
        self.methodArgs = {}
        self.methodArgCount = 0


    def updateArgsValues(self, values):
        for p in self.methodArgs:
            self.methodArgs.update({ p: values.get( p, None ) })

        return self.methodArgs


    def parseRouteRule(self, rule, methodName, methodArgCount, moduleName, moduleFilepath):
        parts = rule.strip('/').split('/')

        for r in reversed( parts ):
            if (r.startswith(':')):
                self.methodArgs.update({r.lstrip(':'): None})
            else:
                self.paths.insert(0, r)

        self.id = self.paths[0] or 'default'
        self.moduleName = moduleName
        self.moduleFilename = moduleFilepath.split( os.path.sep ).pop()[:-3]
        self.moduleFilepath = moduleFilepath
        self.methodName = methodName
        self.methodArgCount = methodArgCount

        return self



class RoutesContainer(object):
    def __init__(self):
        object.__init__(self)
        self._rules = {}
        pass


    def add(self, rule, methodName, methodArgCount, moduleName, moduleFilePath):
        route = RouteAction().parseRouteRule(rule, methodName, methodArgCount, moduleName, moduleFilePath)
        self._rules.update({ rule: route })

        return route


    def find(self, route):
        if (not route): return

        for rule, routeitem in self._rules.iteritems():
            if (route.lower() == routeitem.id.lower()):
                return routeitem

        return

