# -*- coding: utf-8 -*-

'''
    Kodious
    Copyright (C) 2016 Hamid_PaK

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import json as json_lib

from kodi import *
from listitem import *
from client.url import Url
from view_dialog import AddonModuleViewDialog


class AddonModuleView(object):
    def __init__(self, parent):
        object.__init__(self)

        self._parent = parent
        self._list = []
        self._addonName = parent._name
        self._addonHandle = parent._handle
        self._addonSystemURL = parent._system_url
        self._lang = self._parent.language

        self.dialog = AddonModuleViewDialog( self )
        pass


    def addRouteItem(self, routeParams, label, **kwargs):
        # gets the localized string by it's ID
        if isinstance(label, int):
            label = self._lang.get( label )

        # creates a URL
        url = Url(self._addonSystemURL, query=routeParams)

        # creates a list item
        item = GenericListItem(path=url.getUrl(), label=label, **kwargs)

        # appends to the list
        self._list.append( item )

        # returns the current list item
        return item


    def addRouteDirItem(self, routeParams, label, **kwargs):
        # gets the localized string by it's ID
        if isinstance(label, int):
            label = self._lang.get( label )

        # creates a URL
        url = Url(self._addonSystemURL, query=routeParams)

        # gets the info values for this list item
        infoValues = kwargs.get('infoValues', {})

        # gets the art values for this list item
        artValues = kwargs.get('artValues', {})

        # checks for default fanart picture
        if 'addDefaultFanart' in kwargs:
            artValues['fanart'] = self._parent.getFanart()

        # creates a dir list item
        item = DirListItem(path=url.getUrl(), label=label, infoValues=infoValues, artValues=artValues)

        # appends to the list
        self._list.append( item )

        # returns the current list item
        return item


    def insertItem(self, item, index=None):
        # gets length of current list
        if not index:
            index = len(self._list)

        # inserts the item into the list
        self._list.insert(item, index)

        return item


    def refresh(self):
        return xbmc.executebuiltin('Container.Refresh')


    def flush(self):
        self._list = []


    def content(self, content):
        '''
        Sets the view content.

        Parameters:
            content string - content type (eg. movies)
            Available content strings
                files, songs, artists, albums, movies, tvshows, episodes, musicvideos
        '''
        xbmcplugin.setContent(self._addonHandle, content)


    def render(self, succeeded=True, cacheToDisc=True, updateListing=None, sortMethod=None, label2Mask=''):
        items = [x.asTuple() for x in self._list]
        xbmcplugin.addDirectoryItems(self._addonHandle, items, len(items))

        if sortMethod:
            xbmcplugin.addSortMethod(self._addonHandle, sortMethod, label2Mask)

        xbmcplugin.endOfDirectory(self._addonHandle, succeeded=succeeded, cacheToDisc=cacheToDisc)


