# -*- coding: utf-8 -*-

'''
    Kodious
    Copyright (C) 2016 Hamid_PaK

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''

import os
import sys
import time
import json

from . import ClassWrapper


LOGDEBUG = 0
LOGERROR = 4
LOGFATAL = 6
LOGINFO = 1
LOGNONE = 7
LOGNOTICE = 2
LOGSEVERE = 5
LOGWARNING = 3

def log(msg, level = 2):
    '''
    Write a string to XBMC's log file and the debug window.
 
        msg : string - text to output.
        level : [opt] integer - log level to ouput at. (default=LOGNOTICE)

        *Note, You can use the above as keywords for arguments and skip certain optional arguments.
        Once you use a keyword, all following arguments require the keyword.

        Text is written to the log for the following conditions.
        - loglevel == -1 (NONE, nothing at all is logged)
        - loglevel == 0 (NORMAL, shows LOGNOTICE, LOGERROR, LOGSEVERE and LOGFATAL)
        - loglevel == 1 (DEBUG, shows all) See pydocs for valid values for level.     
    '''
    if 0 < level < 8:
        level = 2

    levels = [
        'LOGDEBUG',
        'LOGINFO',
        'LOGNOTICE',
        'LOGWARNING',
        'LOGERROR',
        'LOGSEVERE',
        'LOGFATAL',
        'LOGNONE',
    ]
    print '{level}:{msg}'.format(level=levels[ level ], msg=msg)


def sleep(_time):
    '''
    Sleeps for 'time' msec.

    time : integer - number of msec to sleep.

    *Note, This is useful if you have for example a Player  class that is waiting
    for onPlayBackEnded() calls.

    Throws: PyExc_TypeError, if time is not an integer.
    '''
    time.sleep(_time / 1000)


def translatePath(path):
    '''
    Returns the translated path.
 
    path : string or unicode - Path to format
     
    *Note, Only useful if you are coding for both Linux and Windows.
     
    e.g. Converts 'special://masterprofile/script_data' -> '/home/user/XBMC/UserData/script_data' on Linux.
    '''
    try:
        config_file = os.path.join( os.getcwd(), '.kodious' )
        with open(config_file, 'r+') as f:
            config_data = f.read()
    except IOError:
        config_data = '{}'

    configs = json.loads(config_data)

    valid_dirs = ['xbmc', 'home', 'temp', 'masterprofile', 'profile',
        'subtitles', 'userdata', 'database', 'thumbnails', 'recordings',
        'screenshots', 'musicplaylists', 'videoplaylists', 'cdrips', 'skin',
    ]

    assert path.startswith('special://'), 'Not a valid special:// path.'
    parts = path.split('/')[2:]
    assert len(parts) > 1, 'Need at least a single root directory'
    assert parts[0] in valid_dirs, '%s is not a valid root dir.' % parts[0]

    _dirs = {
        'profile': os.path.expanduser( configs.get('kodi_userdata_path', '~/') ).rstrip( os.path.sep ),
    }

    special_dir = parts[ 0 ]

    return path.replace('special://' + special_dir, _dirs[ special_dir ]).rstrip( os.path.sep ) + os.path.sep



Player = ClassWrapper(object, 'xbmc.Player')
PlayList = ClassWrapper(object, 'xbmc.PlayList')