#!/bin/bash

DRIVER_NAME=openvfd
SERVICE_NAME=OpenVFDService
STOP_SERVICE=stop_service.sh
VFD_CONF=/storage/.config/vfd.conf
AUTO_START=/storage/.config/autostart.sh
DEST_DIR=/storage/.local/share/openvfd
INSMOD_CMD=
if [ -d "$DEST_DIR" ] && [ ! -L "${DEST_DIR}" ]; then
	sh uninstall.sh
else
	sh stop_service.sh
fi

mkdir -p $DEST_DIR
cp -p $SERVICE_NAME $DRIVER_NAME.ko $STOP_SERVICE $DEST_DIR

if [ -f "$VFD_CONF" ]; then
	source $VFD_CONF
	additional_params=
	[ ! -z $vfd_gpio0 ] && additional_params="$additional_params"vfd_gpio0=$vfd_gpio0" " 
	[ ! -z $vfd_gpio1 ] && additional_params="$additional_params"vfd_gpio1=$vfd_gpio1" " 
	[ ! -z $vfd_gpio2 ] && additional_params="$additional_params"vfd_gpio2=$vfd_gpio2" " 
	[ ! -z $vfd_gpio3 ] && additional_params="$additional_params"vfd_gpio3=$vfd_gpio3" " 
	INSMOD_CMD="insmod $DEST_DIR/$DRIVER_NAME.ko vfd_gpio_clk=$vfd_gpio_clk vfd_gpio_dat=$vfd_gpio_dat vfd_gpio_stb=$vfd_gpio_stb vfd_chars=$vfd_chars vfd_dot_bits=$vfd_dot_bits vfd_display_type=$vfd_display_type $additional_params"
else
	INSMOD_CMD="insmod $DEST_DIR/$DRIVER_NAME.ko"
fi

$INSMOD_CMD
$DEST_DIR/$SERVICE_NAME &

echo sh $DEST_DIR/$STOP_SERVICE >> $AUTO_START
echo $INSMOD_CMD >> $AUTO_START
echo $DEST_DIR/$SERVICE_NAME' &' >> $AUTO_START
