#!/bin/bash

source ./stop_service.sh

if [ $# -eq 0 ]; then
	echo "No command line options were found, showing usage instructions."
	./OpenVFDService -h
fi

vfdconf="/storage/.config/vfd.conf"
if [ -f "$vfdconf" ]; then
	source $vfdconf	
	additional_params=
	[ ! -z $vfd_gpio0 ] && additional_params="$additional_params"vfd_gpio0=$vfd_gpio0" " 
	[ ! -z $vfd_gpio1 ] && additional_params="$additional_params"vfd_gpio1=$vfd_gpio1" " 
	insmod "$(pwd)/openvfd.ko" vfd_gpio_clk=$vfd_gpio_clk vfd_gpio_dat=$vfd_gpio_dat vfd_gpio_stb=$vfd_gpio_stb vfd_chars=$vfd_chars vfd_dot_bits=$vfd_dot_bits vfd_display_type=$vfd_display_type $additional_params
else
	insmod "$(pwd)/openvfd.ko"
fi

./OpenVFDService "$@" &