#!/bin/sh

# $1 added to support 1st line argument. i.e. "/storage/Listen_to_LineIn_on_LineOut_vk.sh -q" wi$

# mute speaker output
amixer $1 -Dhw:sndrpiwsp cset name='Speaker Digital Switch' off

# reset speaker mixer inputs
amixer $1 -Dhw:sndrpiwsp cset name='HPOUT2L Input 1' None
amixer $1 -Dhw:sndrpiwsp cset name='HPOUT2R Input 1' None
amixer $1 -Dhw:sndrpiwsp cset name='HPOUT2L Input 2' None
amixer $1 -Dhw:sndrpiwsp cset name='HPOUT2R Input 2' None

# Vijay Edit START

# Route AP to Speaker mixer
amixer $1 -Dhw:sndrpiwsp cset name='HPOUT2L Input 1' AIF1RX1
amixer $1 -Dhw:sndrpiwsp cset name='HPOUT2L Input 1 Volume' 32
amixer $1 -Dhw:sndrpiwsp cset name='HPOUT2R Input 1' AIF1RX2
amixer $1 -Dhw:sndrpiwsp cset name='HPOUT2R Input 1 Volume' 32

# Route Line In to Speaker mixer
amixer $1 -Dhw:sndrpiwsp cset name='HPOUT2L Input 2' IN3L
amixer $1 -Dhw:sndrpiwsp cset name='HPOUT2L Input 2 Volume' 32
amixer $1 -Dhw:sndrpiwsp cset name='HPOUT2R Input 2' IN3R
amixer $1 -Dhw:sndrpiwsp cset name='HPOUT2R Input 2 Volume' 32

# "IN3L Volume"/"IN3R Volume" control the analog input gain (before the ADC).
# Default is 0 (0dB), 1 is +1dB etc. Usually values between 0 and 8 should be OK (depending on the analog signal level).
amixer $1 -Dhw:sndrpiwsp cset name='IN3L Volume' 30
amixer $1 -Dhw:sndrpiwsp cset name='IN3R Volume' 30

# "IN3L Digital Volume"/"IN3R Digital Volume" control the gain in the digital domain (after the ADC).
# Usually it's best to keep that at the default 128 which means 0dB (i.e. no volume change).
amixer $1 -Dhw:sndrpiwsp cset name='IN3L Digital Volume' 128
amixer $1 -Dhw:sndrpiwsp cset name='IN3R Digital Volume' 128

# Vijay Edit END

# Unmute speaker output
amixer $1 -Dhw:sndrpiwsp cset name='Speaker Digital Switch' on

#Playback from AP to Speaker
amixer $1 -Dhw:sndrpiwsp cset name='Speaker Digital Volume' 128
