#!/bin/bash

LANG=en_US.UTF-8
export LANG

. /etc/profile
. /etc/os-release
SHORT=$(echo $VERSION_ID | sed -e 's|\.||g')

if [ $# -ne 1 ] ; then
	echo "usage: $0 <fs label>"
	exit
fi

eval `cat /proc/cmdline | sed -e 's|\s|\n|g' | egrep '^CL|^disk='`
MAC=$(/storage/.cryptluks/get-mac.sh)
FOODISK=${CLdev}
FOOUSER=${MAC}:${CLpas}

mkdir /tmp/mnt /var/cl 2>/dev/null

# create a key
echo "# on the key server as root"
echo "cd /webdav/htdocs/users/${MAC} && openssl rand 8192 >${MAC}-${SHORT} && chmod 0440 ${MAC}-${SHORT} && chgrp apache ${MAC}-${SHORT}"
# and get key
echo ""
echo "on the kodi system"
echo "curl --insecure --tlsv1.2 --silent --output /var/cl/$MAC --user ${FOOUSER} https://${CLsrv}:8443/${MAC}-${SHORT} && ls -la /var/cl/$MAC"

# create cryptluks
echo "cryptsetup luksFormat --key-slot 1 --iter-time 5000 --cipher aes-xts-plain64 --key-size 512 --hash sha512 --verify-passphrase --use-random $FOODISK"
echo "cryptsetup luksAddKey --key-slot 2 --iter-time 5000 $FOODISK /var/cl/$MAC"

# try to mount
echo "cryptsetup luksOpen $FOODISK luks-${FOODISK##/*/} --key-file /var/cl/$MAC"
echo "mkfs.ext4 -L $1 /dev/mapper/luks-${FOODISK##/*/}"
echo "mount /dev/mapper/luks-${FOODISK##/*/} /tmp/mnt"
echo "touch /tmp/mnt/.cryptluks_mounted"
echo "systemctl stop kodi && rsync -avHx /storage/.kodi/userdata/ /tmp/mnt"
echo "umount /tmp/mnt"
echo "cryptsetup luksClose luks-${FOODISK##/*/}"
echo "systemctl enable /storage/.cryptluks/cryptluks.userdata.service"
echo "# sync other data from /storage"
echo "mount $disk /tmp/mnt ; rm -rf /tmp/mnt/.kodi/userdata/ ; rsync --delete --exclude=userdata/ -avHx /storage/ /tmp/mnt ; mkdir /tmp/mnt/.kodi/userdata/ ; umount /tmp/mnt"

