#!/bin/bash

FD628=$(systemctl | grep running | grep fd628)
if [ ! -z "$FD628" ]; then
	systemctl stop fd628
fi

for FD628 in $(ps aux | grep '[F]D628Service' | awk '{print $1}'); do
	if [ ! -z "$FD628" ]; then
		kill $FD628
	fi
done

FD628=$(lsmod | grep aml_fd628)
if [ ! -z "$FD628" ]; then
	rmmod aml_fd628
fi

if [ $# -eq 0 ]; then
	echo "No command line options were found, showing usage instructions."
	./FD628Service -h
fi

vfdconf="/storage/.config/vfd.conf"
if [ -f "$vfdconf" ]; then
	source $vfdconf	
	insmod "$(pwd)/aml_fd628.ko" vfd_gpio_clk=$vfd_gpio_clk vfd_gpio_dat=$vfd_gpio_dat vfd_gpio_stb=$vfd_gpio_stb vfd_chars=$vfd_chars vfd_dot_bits=$vfd_dot_bits vfd_display_type=$vfd_display_type
else
	insmod "$(pwd)/aml_fd628.ko"
fi

./FD628Service "$@" &