#!/bin/bash

DRIVER_NAME=aml_fd628
SERVICE_NAME=FD628Service
STOP_SERVICE=stop_service.sh
VFD_CONF=/storage/.config/vfd.conf
AUTO_START=/storage/.config/autostart.sh
DEST_DIR=/storage/.local/share/fd628
INSMOD_CMD=
if [ -d "$DEST_DIR" ] && [ ! -L "${DEST_DIR}" ]; then
	sh uninstall.sh
else
	sh stop_service.sh
fi

mkdir -p $DEST_DIR
cp -p $SERVICE_NAME $DRIVER_NAME.ko $STOP_SERVICE $DEST_DIR

if [ -f "$VFD_CONF" ]; then
	source $VFD_CONF	
	INSMOD_CMD="insmod $DEST_DIR/$DRIVER_NAME.ko vfd_gpio_clk=$vfd_gpio_clk vfd_gpio_dat=$vfd_gpio_dat vfd_gpio_stb=$vfd_gpio_stb vfd_chars=$vfd_chars vfd_dot_bits=$vfd_dot_bits vfd_display_type=$vfd_display_type"
else
	INSMOD_CMD="insmod $DEST_DIR/$DRIVER_NAME.ko"
fi

$INSMOD_CMD
$DEST_DIR/$SERVICE_NAME &

echo sh $DEST_DIR/$STOP_SERVICE >> $AUTO_START
echo $INSMOD_CMD >> $AUTO_START
echo $DEST_DIR/$SERVICE_NAME' &' >> $AUTO_START
