import sys
from subprocess import Popen, PIPE, check_output
import re

import xbmc
import xbmcaddon
import xbmcgui

# Get addon info
addon = xbmcaddon.Addon()
addonname = addon.getAddonInfo('name')

# Get settings
username = addon.getSetting('username')
hostname = addon.getSetting('hostname')
remote_path = addon.getSetting('remote_path').rstrip('/')
local_path = addon.getSetting('local_path').rstrip('/')
video_update = addon.getSetting('video_update')
music_update = addon.getSetting('music_update')

# Do this until we mount the drive
drive_mounted = False

while drive_mounted != True:
	# Get password
	password = xbmcgui.Dialog().input("Password for \'" + hostname + "\'...", "", xbmcgui.INPUT_ALPHANUM, xbmcgui.ALPHANUM_HIDE_INPUT)

	# Attempt to connect with SSHFS	
	proc = Popen(['sshfs', username + '@' + hostname + ':' + remote_path, local_path, '-o', 'password_stdin'], stdout=PIPE, stdin=PIPE, stderr=PIPE)
	proc.communicate(password)

	# Check to see if the drive is mounted
	mount_output = check_output('mount')

	# Create our search line
	regex = username + "@" + hostname + ":" + remote_path + " on " + local_path + " type .+sshfs"

	# Examine the output from mount
	for line in mount_output.split("\n"):
		if re.search(regex, line):
			drive_mounted = True
			break	

	# If mounted, notify the user
	if drive_mounted:
		xbmcgui.Dialog().notification(addonname, "SSHFS mounted successfully.")
		
		# Begin library updates, if applicable
		if video_update:
			xbmc.executebuiltin('UpdateLibrary(video)')
		if music_update:
			xbmc.executebuiltin('UpdateLibrary(music)')

	# Otherwise, ask if they want to try again
	else:
		try_again = xbmcgui.Dialog().yesno("Error!", "The SSHFS mount could not be completed (bad password?).", "Would you like to retry?")
		if try_again != True:
			sys.exit(1)
		



