#!/bin/bash
#VLC script of MPD II AverMedia

# global variables used throughout the script
export ROOT=`(cd \`dirname $0\`; pwd)`
export model
export input
export frequency
export standard
export STD
export height
export video
export audio
export dvb
export parameter_number
 
export ask_model="yes"
export ask_input="yes"
export ask_frequency="yes"
export ask_standard="yes"
export ask_external_standard="yes"
export ask_video="yes"
export ask_audio="yes"
export ask_dvb="yes"

fail_integrity() 
{
	echo "Please make sure the integrity of the script files"
	exit 1
}

# import script functions
test ! -e "$ROOT/vlc-script-functions" && fail_integrity 

. $ROOT/vlc-script-functions

run_vlc="yes"
parameter_number=$#
make_v4l_query="no"
make_dvb_query="no"

# make query binary
test ! -e "$ROOT/v4l_query" && make_v4l_query="yes"
test ! -e "$ROOT/dvb_query" && make_dvb_query="yes" 

if [ $make_v4l_query == "yes" ]; then
  test ! -e "$ROOT/v4l_query.c" && fail_integrity
  test ! -e "$ROOT/videodev.h" && fail_integarity 
  test ! -e "$ROOT/videodev2.h" && fail_integrary 
  gcc -o v4l_query v4l_query.c > /tmp/log 2>&1
fi

if [ $make_dvb_query == "yes" ]; then
  test ! -e "$PWD/dvb_query.c" && fail_integrity
  gcc -o dvb_query dvb_query.c > /tmp/log 2>&1
fi

# just show help
if [ "$parameter_number" == "1" ] || [ x"$1" == x"-h" ]; then
  usage $0
  endscript
fi

# parse parameters
if [ "$parameter_number" != "0" ]; then
  while [ "$parameter_number" != "0" ]
  do
    case $1 in
      "-h")
      usage $0
      shift 1
      ;;
      "-m")
      get_model $2
      shift 2
      ;;
      "-i")
      setup_input $2
      shift 2
      ;;
      "-f")
      setup_frequency $2
      shift 2
      ;;
      "-s")
      setup_standard $2
      shift 2
      ;;
      "-e")
      setup_external_standard $2
      shift 2
      ;;
      "-v")
      setup_video $2
      shift 2
      ;;
      "-a")
      setup_audio $2
      shift 2
      ;;
      "-d")
      setup_dvb $2
      shift 2
      ;;
      *)
      echo "unknown parameter! --> $1"
      usage $0      
      shift $parameter_number       
      ;;      
    esac
    parameter_number=$#
    #echo "parameter_number:$parameter_number"
  done
fi

# ask miss parameters
if [ "$ask_model" == "yes" ]; then
  ask_model_function
fi

if [ "$ask_input" == "yes" ]; then
  ask_input_function
fi

if [ "$ask_video" == "yes" ]; then
  ask_video_function
fi

if [ "$ask_dvb" == "yes" ]; then
  ask_dvb_function
fi

if [ "$ask_standard" == "yes" ] && [ "$ask_external_standard" == "yes" ]; then
  ask_standard_function
fi

if [ "$ask_frequency" == "yes" ]; then
  ask_frequency_function
fi

if [ "$ask_audio" == "yes" ]; then
  ask_audio_function
fi

# run VCL
if [ "$run_vlc" == "yes" ]; then
  VLC_command
fi  

echo "Script END"
