/* ========================================================================== */
/*                                                                            */
/*   vlc_query.c                                                              */
/*   (c) 2011 Author MPDII AverMedia                                                          */
/*                                                                            */
/*   Description                                                              */
/*                                                                            */
/*                                                                            */
/*   To compile: gcc -Wall -o v4l_query v4l_query.c                           */
/* ========================================================================== */

#include <unistd.h>
#include <string.h>
#include <sys/mman.h>
#include <asm/types.h>

#include <stdlib.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include "videodev2.h"
#include "videodev.h"

#define	VER_V4L2	0
#define	VER_V4L		1

static int gVersion;  //VER_V4L2 as default

/*
 * In	: fd - open to check
 * Out	: gVersion
 */
static void check_device(int fd)
{
	int err;
	struct v4l2_capability v2cap;
	struct video_capability v1cap;
	char buffer[32];

  memset(buffer, 0, sizeof(buffer));
  
	//don't clean to make sure drvier fill each field
	err = ioctl(fd, VIDIOC_QUERYCAP, &v2cap);
	if( err ) {	//no v4l2 support
		err = ioctl(fd, VIDIOCGCAP, &v1cap);
		if( err ) {
			printf("None of V4L and V4L2 support !!!\n");
			exit(1);
		}
		gVersion = VER_V4L;
		memcpy(buffer, &(v1cap.name), sizeof(buffer));
		printf("name-->%s\n", buffer);
    printf("type-->%d\n", v1cap.type);
    //printf("channels-->%d\n", v1cap.channels);
    //printf("audios-->%d\n", v1cap.audios);
    //printf("maxwidth-->%d\n", v1cap.maxwidth);
    //printf("maxheight-->%d\n", v1cap.maxheight);
    //printf("minwidth-->%d\n", v1cap.minwidth);
    //printf("minheight-->%d\n", v1cap.minheight);
	} 
  else {
    gVersion = VER_V4L2;
    printf("driver-->%s\n", (char*)v2cap.driver);
    printf("card-->%s\n", (char*)v2cap.card);
    printf("bus_info-->%s\n", (char*)v2cap.bus_info);
    //memcpy(buffer, &v2cap.version, sizeof(buffer));
    //printf("version-->%s\n", buffer);
    //memset(buffer, 0, sizeof(buffer));
    //memcpy(buffer, &v2cap.capabilities, sizeof(buffer));
    //printf("capabilities-->%s\n", buffer);
    //memset(buffer, 0, sizeof(buffer));
    //memcpy(buffer, &v2cap.reserved, sizeof(buffer));
    //printf("reserved-->%s\n", buffer);
  }
  return;  
}

int main(int argc, char *argv[])
{
  int fd;
  char *filename;
  gVersion=0;

  filename = argv[1];
  fd = open(filename, O_RDWR);
  if( fd<0 ) 
  {
    perror(filename);
    exit(1);
  } 
  check_device(fd);
  close(fd);

  return 0;
}
