#!/bin/bash
BASE=`(cd \`dirname $0\`; pwd)`
THIS=`basename $0`
END_OF_SCRIPT=187
MD5SUM=265a9cc9aee97e582f34df2760b44816
TMPDIR=/tmp/avm-install

install_package()
{
	local package="$1"

	if [[ "$package" == "" ]]; then
		echo "install_package: empty parameter, abort"
		return
	fi

	if which apt-get >/dev/null 2>&1; then
		echo "Installing package \"$package\", please wait a moment ...."
		apt-get -f install $package
	elif which yum >/dev/null 2>&1; then
		echo "Installing package \"$package\", please wait a moment ..."
		yum -y install $package
	else
		echo "Don't know how to  install package \"$package\", aborting installation."
		echo "Please install \"$package\" manually before using this installer."
		exit
	fi

}

#=========================================
# Script starts from here
#=========================================

# depmod may need this, if user is not logged in as root
export PATH="$PATH:/sbin;/usr/sbin"

#jim108+s
log_file="$HOME/driver_install_log.txt"

#Create LOG file
echo > $log_file

date=$(date)
echo "Date: $date" > $log_file

#Add machine type
echo "Machine type: $MACHTYPE" >> $log_file

#gcc version
echo "gcc version: " >> $log_file
gcc --version >> $log_file

if [[ "$?" != "0" ]]; then
	echo "gcc version failed, abort." | tee -a $log_file
	exit
fi

if [ -e /proc/asound/cards ]; then
    echo "===== START /proc/asound/cards ======" >> $log_file
    cat /proc/asound/cards >> $log_file
    echo "===== END /proc/asound/cards ======" >> $log_file
    echo >> $log_file
fi

if [ -d /lib/modules/`uname -r`/ ]; then
    echo "===== START /lib/modules/... ======" >> $log_file
    (cd /lib/modules/`uname -r`/ >> $log_file 2>&1; ls -al >> $log_file 2>&1 )
    echo "===== END /lib/modules ... ======" >> $log_file
    echo >> $log_file
fi

if [ -e /etc/lsb-release ]; then
    echo "===== START /etc/lsb-release ======" >> $log_file
    cat /etc/lsb-release >> $log_file
    echo "===== END /etc/lsb-release ======" >> $log_file
    echo >> $log_file
fi

if [ -e /etc/system-release ]; then
    echo "===== START /etc/system-release ======" >> $log_file
    cat /etc/system-release >> $log_file
    echo "===== END /etc/system-release ======" >> $log_file
    echo >> $log_file
fi

if [ -e /etc/issue ]; then
    echo "===== START /etc/issue ======" >> $log_file
    cat /etc/issue >> $log_file
    echo "===== END /etc/issue ======" >> $log_file
    echo >> $log_file
fi

if [ -e /etc/issue.net ]; then
    echo "===== START /etc/issue.net ======" >> $log_file
    cat /etc/issue.net >> $log_file
    echo "===== END /etc/issue.net ======" >> $log_file
    echo >> $log_file
fi

#Log VLC version
echo "VLC version: " >> $log_file
test -e "$HOME/.config/vlc/vlcrc" &&
head -n 3 $HOME/.config/vlc/vlcrc >> $log_file

test ! -e "$HOME/.config/vlc/vlcrc" &&
echo "$HOME/.config/vlc/vlcrc not exist!" >> $log_file

#Log mplayer version
echo "mplayer version: " >> $log_file 2>&1
mplayer --help 2>&1  |tail -n 3 >> $log_file 

#Log kernel version
kernel_version=$(uname -r)
echo "Kernel_version: $kernel_version" >> $log_file
 
source_tree_path="/lib/modules/$kernel_version"
echo "Source tree: $source_tree_path" >> $log_file
 
#Check kernel header
if [ ! -e "$source_tree_path/build" ]; then
	echo "$source_tree_path/build not exist!" | tee -a $log_file 
	exit
fi

echo "$source_tree_path/build found." | tee -a $log_file
ls -l $source_tree_path|grep 'build' >>  $log_file

#Log kernel config
echo "Kernel Config: " >> $log_file
test -e "/boot/config-$kernel_version" &&
cat /boot/config-$kernel_version >> $log_file

if ! which bzip2 >/dev/null 2>&1; then
	echo "\"bzip2\" is not installed on your system, try to install." | tee -a $log_file
	
	install_package "bzip2"
fi

rm -rf $TMPDIR
mkdir -p $TMPDIR

if [[ "$?" != "0" ]]; then
	echo "Failed to create temporary working directory, abort." | tee -a $log_file
	exit
fi

cd $TMPDIR

# verify MD5 checksum
CHECKSUM=`tail -n +${END_OF_SCRIPT} $BASE/$THIS | md5sum /dev/stdin | awk '{print $1}'`
echo "Verifying archive integrity..." | tee -a $log_file
if [[ "$CHECKSUM" != "$MD5SUM" ]]; then
	echo "Archive integrity check failed. This installer is corrupted." | tee -a $log_file
	exit
fi

# extract archive and invoke installer
echo "Extracting archive..." | tee -a $log_file
tail -n +${END_OF_SCRIPT} $BASE/$THIS | bzip2 -d | tar xf - >/dev/null 2>/tmp/.err
if [[ "$?" != "0" ]]; then
	echo "Failed to extract installer, abort." | tee -a $log_file
	cat /tmp/.err >> $log_file
	exit
fi

echo "Running installer..." | tee -a $log_file

cd installer
bash -i ./installer.sh

# clean up
cd $BASE	
rm -rf $TMPDIR

#Log dmesg
echo "========== Start of dmesg ===========" >> $log_file
dmesg | tail -n 500 >> $log_file

echo
echo "Install log generated on $log_file"
echo

exit

==END_OF_SCRIPT==
BZh91AY&SY~ B"! %b<T)AJ 
 !RU*rn
 J  	PI4݃{P9g]ue2*n4U΃Ƿ[7m;n@̻stuܥӀ]E uW뽍ӝnk>   >҄ltn -E78uu]3M8Zjl *wgn6nu]gz5jܸ	R_{{Þ+-F=o//m9
 {˦xv넜r +ў{%MTmhMVrl(Dg
RR/[hJ<#8 {% p@ i@ ڀ    P>T 4/{z(-) @4l|  W9AdJ/X%t˰>mRnY<|}`7pv  ݀%AsWɶxK0djqvGiTݦj%P]ϛA]\k>DvfYmwlݢ2Avr
SۊWy
,8;=Zno{z[wG"[2{{۷޽|E`WwϽ6ƠIR
P{h40h
4
 $%jN 
*^
݁G4BH$A@Ґx5CSPUM k_m_osoxmPupEPza:`=`}re.H;ZFs$%27gRuvr HNA;UZk< وZנ+ҩ%뻾gүovm:x]3dJ'f5*u{-P4L/Mk[ocO<{Of[rzzURqWV3.{p6erYXq꛱iRH=+$4]鞱{{YMdqg+k.ݔ+'[umݣ]焯q\{kXWe4e)=:}nѶ|ڳo6Rm2qfyKZ݇zW'XyxjdmӧO7%A{ׅ7C'=f}Cf:e
7z׼l  u;gV3
ۻA:uZoC#l֮PݚWNjPSUhQrqKѸ6 JWLfbjqVTV]T47vJ+̣va{Ҍ*bSk'CDy苖
iRH띂Z]Km,WMy^mn+(*
 M-w^xe^] ıHf}9$>zveM@):Ύj"m{҅)tm
ޝih     }(     C@#@2hMSa?Q=O~5  d jzHDAjOJ~~=C=F@2
  
   #Q$A4&&LOJQ=FMGAz !    z$Bd&"xzdh
 dh     B@  &S11CA2b
'&SɩiDd=A"    )Oɒh$d2  ocC)rr߸Z!Wֺ-@E_>rDC Uu~۽Գ%ⳏUV3xޙ֨a2i
DpwI""!@M!^1;N^j:8D=FA,*Lm4Z΀PB݉١Rqd2C.% E=(i*nԮEetZF)_`D&.bٌ
2DԪNY,I5
RhLBHE )1) |%eHfKk5+,ԩ*a$0I!HJشiҖzU ւLXΔF
VvD)E3ZR
71	TD	%Jh,))ԪWUUKm1V
\A	@
rSP0A)!lmRlʂ2J5J@AX 1*h	@ZZ
BP(3YKHz*#x"`S@.ZI	];1P4H0qTaTҥD eSJ큳a8ق8JL5 
Y"bvWB	dUJL62 1$J`h!JC'FA QBan!Jy2?jEsy0"Cp!6[
rpDP$z *CB!HJHo `soaxѽQ_(B*<tK	H]RHŚfFɔcZ2%4DSDMK%2MBX-
,21&PӆY`!K`)'da0dYB
hdUKxΛlٙF),oK{]tVL-ߟSo0alcBDHbSF)I aJYlَ
*B4nkbFix%0t}B?O	@1ˀ@gƯoW_B$@[`PF)|5ӏhU!QTSUej͖Ѥfm  c&icY2V	I%%RQ
Mf#d4^2JJ(&&GDfk˱TɤdǲCS6fhV2bAEjMI}m\TBBUe5ͨ(T&ljeRцS{6"Jʹ%l&dlT*JOM-!)=1x#	a1Ͱ٭Wud5-əS-mU2,ƅYXL̴FI+3DQ4[5kI5$lZfRLfY{t[I%(ⅴIlQ
64$ReRU+,[hLRH*B@Q#244">0koOf&NG+o 774\Asn92ҌBĬ"Iv]ShRPj6 @R,LJ(RZ$٥ItDZ&St1PVjmDb6FWeJP%BI>[F*ZӌIim%Kidfm5U)T	I"D!p%ݵtUO9kcSsLDM]iR6M,LwA/]^y֗4٦vL	4f`C,PaIvLfU3nJ4j]Aѭlg;],)Z5fF	`Rn"[JF@|ۃ^50HFgaKz)|ҐbiZv0`DL[U$$f%kƹ3zu&hokRI[rYkVCI!sh6>N:zrEDLT}m4gW\l֚Fe*z?a۳G`BmRYW'9vi^L˟ZƦۑ(b
(>,P	`u15ź
@F1ܩ'3/?4kX)ij1.ҎzQwOa:ѐUUTQTP?=GcZvFsNH*ZkY mDDJR29 oZP$Ml4h"$<rYS4)j"&i-uԫ[+H)!~K)
 ,LjY)P2HK3C4)(QJJB2KEf"LfJ4)iّdƚiMc)e(ɗ;g]wNkEb1&
Kwr6ҫJlZd4-&)c[$ HJSfɲJT-{t$K36M&d]1KRD_9iR $H"A
&H̦[	%JVi1EG,w6`#Ҙ( *Y$&4i&ki!6-lQLbonfTє$ʔS-j4*(&ҥiiaMіfj5d"֋FVPbY*f6V6 M^PfLMdYM2&bI&3QZ&-bWLԴ۹cGf%Y:+M4mRR32&)
Rm*6%)P3mR%m3[MI+)"T6XkEkfTF--fY)b1%4J(]K44VTRAb ͵-֖VVZJ$%&dcRVR JhQ;T0!ZyΉכQ	e&hm54ɖ&(BN` \MZ]))JKRZ*+eM[RUKo<q%fI[JR[J%Rm!)Klt9)AMg-w(Wl_DZBA= )iI5,R+MEjaE76ȌdGpuv&Sa񴬨6:=R82'`M8G"+"A^'Q	.dˊV
"G$cO1*PdCNhG!!e%8Cy]y ,Ib{gÁ1_ dBq7E[DE2I_) $Qͬҩoc8;~" "{`_zx[/lE7찝Z?ı{r\{i"Pw}~4P!yWhxL磳z
_M TE@EE<!JqlcpbDRǳSdб*?~|y(`G5&Nؓf	rZ`C0+D,fv^7vM2w }<3g̥6m
''AgPQ

M1pDL	98d͛d3pP^SEq$*K\CLtK4CX壶ɘLQ[G7b'ynT?46laMv&vJ.$Vʏ|̝Mnk%dLՇ!&hAݎ+JVz*+AvSvakʔ7嵣lQP>JYBaXZ=>Oiu<ϼcyO>jЦϝh|iܢKҾ+=SY&<m(.TNM@*	UHPA
D^z
r#mNѵtZTcSftt\(Yokf?&)1
,vq~v&U%7:ؽI@qfJ.Ӄ"62:$l0WfIގt0Vg
HJX<eFo㯀=i^Q='pka
C^iqg[I$4Y->[01қ:uՎFÅRz'g9OzNCNzZ_O@zrϭK|[ynN^
J:͋bp`@3Hokm5ynvt/CK3hke$Q5 ue%t'rNts?&/K^"BCcXC>l{\Ytyna"]fky_:0j,JEM@=ᾤ`3"Xq,
 jUa0g<:hY{%SYǎpAJ\
IqrдBu#I4&H"cEyhZGyBg.
6]I$ncZ&I$XCXk`'r8M!9m堠HZg8<xHkxn/ݦ\?gMsP9CቕIq[TA(rSmrQf.MloØȁz3h\{YH=pe&f	 Vfٍp\R9JAĨdYOwr?p(FND%H@b1k*m/KF{53{
P$*$ GԬvOÈF!*UzԵ\E$k~秗y5۟1MFU	9IoSo5H%IQL2R=
4P8M'P-d]dɊ <(d%O䚨|
C%ְnvxNyb~H8#yQNJ5fFunM+^iMW\
qCZmv]xѥTl[dWv{a"°3k-mw*xsd6K;mTaO֞]lLSҦh.WUmkX3\%\:Jjworz~?Msx撚z\8 "4`Զz08rl( d-=(a~?^|xzX[cJ-6:m
뭫La?0:ڠv[>Ur01E8JX@3W9ul-YD7wVMOo)Jm|S->Kޒ/)D\".ݳFB|3!FB||=uQ*]reֳx>M<Ͼ-ЈtA9C#S{|N'jͥK<1
HZZľG鸽 y@NAs0H[2XP)lC*[bhiU0@l<~^d[:
ixo,ryfӱFhCap

e}fTb
匧{pc`bl$H@^w'u$aC-]B`GNR"2Q%ടEZ4EƖYKsЩ4]']M7ɶJhٽ7aF"2<](;RmmI'|xp!DN?g3yG<-._
ůJRyr0lY/wq|p^1hĊkBs_.	z1X6hA
]P8:ԅNtqE-{e:-7yizjh4yD[oSM穛)6FKo[ۆ5d(npɖKK-ˇLmkf ^휯B/wV%vtB,0:t枍to&,2lPb]uNi -
Rd6]Є>f4bR&1`&2u,3 06[2ǘ}[6:F[I:8PEC,KJ!Fhxfs(瘅! &1Ȓ
(߫}~_{h2J
e̕urw\<\u7wb
&9zM0D>&6lՍ6ٙelr'5}r3YIifQ
@PZ5iJK+A\/svclXƚ)zR{e6]ӋN0KPm1Ogzbc~ބQ?/v/q_]i(کi^&P6T.Kh{v;$CJfM26kZ;f
ref5J<3%4B^nRbĽ %4!:!8XaifX0o\G|鹎=&lQYEvOq_=;SMPk[[BSv2aeo,߭)K-=9Ǖʍ<\`2W'rS	טc)(ph06!1쌩>'H}9tז0Z
0nIK4;[>-n[&)5[.mٷKaߚnY$Rn_EJ*U(żjF+ƹ>}WbIE%()꼈|ܫ&ĦPG^h?k`htoTҔ)BivAy]g\9ag#}
[ gߎ=fn8N18'I1TTҌ
	f#}yݦsO-O`ݻ
`+7o JI+#aWOهvuQw|NSzǥWԎGCf&l&leGUE'^#'ν;Z	6<aؿ!*jUc9BNI&2i*I$!I*6~=1O߹}j,;2ks"?m0UPsP*B29
[ѱ'}m范AŢTz9tWP|:*VY(d%","*Ճd%ԼO>0ayUWYid0uZB*  "HԑFfi(%>7;N<gb+nA<Ѻ=פчE?TGWQZ70Qe1˭]#J.fmaN?F a`NMEL<9hp$?Q/$O*'άˆ/o7C#*(Ǟ}wjYIeƗPSE4P'DEK6	?aP܆̨b^g/-ɃA 9Cn1KaAϕ6,Jԛޮ0M\Olos^?J?U(r\Eu}O]Uv*n2JsDS-%d9[62\Dgq3ʘ8(
*)uxyJJO>6wxbu+[kGz?s㖸l?4ӑY%t,{֪o8k<<XHq&B"EPv?N]`^sMF}s&%`t:^E*H]J2>|9~$M˖wFKB/+秫3\?솅QC!
Ǭvh̉`|yIbe%m͞Nmݍ=q~RdWN-W;"F!;)=hm9_Bd<jPBAkzx7(o&FEI)|{꥿^x 

u>Y>oR~
&i>叐k
ec*t({GZD
s-OUPǱSKܜ-yT)| `\SOSlF6,,86&q_%U\"38-7f.w;Ϻjdd}prޤUA"hE|67a\_f176޽"|XGԓki'ݍChfAPFhC@J}SdB8"5 a͔<y(<CG@_Z(]EzX_OOM,O]f+9ma{;_(QbѤwGdZ#C'gdLvWf4d<//N4>[}2zJHmw
Yq"e,*ÑvA:G4Qsn%?Bn	E%X?r&n
Y@1Z)`"d#UhaWXG>_qmQՆGoX]A4'nA={.zglziR?|o:D_ۥ ͍oO<wnrcDN@l$ۙgzr&	vm`h`Rai4xv!n==dqV7!'jZgAǧT3oBÙy00ld 43zq7spkDw	,Sъ75Y N3%MAo591&,o%kpdoo3rVͳmv0lR뾍nfߺ"0H*ys2Ћ<(ˇ3
Ldvf4Ej!|Um(x=[q=e]\$$m1C*NTN	5U(UQh4qݶ!ڦ5x&H.3fjpy I,tWA< &o L0)*`澦4sq=.[m,u~_n.b,Zqr#Vr"AɴGpY"^kDk2ihlbkLCA݊,?ȑP*Vjo?I:f%'%3rA1Ȍ_UPUA>+{ <e9<H'܍_ʼ޽wl|b}~~TeI?POu%*1jض TI`[$3h}cpzx}<HXmD;r}n*N֓)Vw4U	/g2Du?rvs'z,t>sfk:\/JKWT33xz~I|6%@[%uDåð^kY @.xrT໕TBwkR_7Iܳ}ZEy#,ˡg_61mA93Ǚ`or`[}/T^˓H[w'z1?6a-:ӻ7C sdv>C~9AZ7ҁ -HO@
J#h< xo^)gUnU]pv鎒d9@OӈM%|5|w~cW@^ =J-(N!O?v)D?;܄P޳Ֆw#\;>ޝv>zCfs^
?mláߦOםSG;ym0sK~tt[e5a!K^
Vly!Er&QL&ϊA3uTdU&H것9_&qUepf2]ܹq92Gw5hP"$Xt1	QfU]^}nH[~*w[tK?pս~;w
Uj/>L1,';
Udrt~KCi5
8I}|g[~gf*@ن7x57ݯ-/䧛HrsS5jeusi~G?V#K&^RUWҬ{,ĐC%qe%~E= o@{qOpw:vyyFrnÇz2ʪY[Ѭ>ߓ~l!{t]g+2C	8#$ƣ9{_뱇{x ?'W׻llm_o=\qu'}]st#6_
l({q@wlޑ8?SmiE/M]|?goA=d}6bUMqdQYf5Tk[{,mOӵ-$k,I$f=&ъ8ē:hat~X2)xqǞ_== ~/]cO\;!8;]_kejU-T*e?D=0zkOUK@ȔH@{Qj-EZQj-EZQj-EZQj-EZQj-EZQj-EZQj-EZQj-EZQj-EZQj-EZQj-EZQj-EZQj-EZQj-EZQj-EZQj-E!


.$')Pm `mC9`<M:Ȇ#T(d	@F@
o	Rpa!,\bFߥ#R";{>N1(?ƾ}>_qmd1<c*t3M?C?V'FSo$L=~.Qߧ0DVbDR|<phzSQwk
cv8/rU'>Pm!"|顓Ñc]Ah<g]6D,j}$QjG^OCGRP(?kfqR"'RڃVȡ H?sx;b{a<!9(zOgzɾ(f` TD})*0kQEs(_BAtڄ|>W/ߕ>Ai HW!cD10ii$1R4 hRl&~{`>c_(h`ͰWVAf4	0$!}: 7>)(3>_goͰeZ3(bP̴NH!'8nt~jy$ֶn/d>0S/  <rpAMؘhƯho;I_p)o:k~~~8^R&'l(\:f`lCTT d%2SR5_3`R|[,jW9au<:mo't"YCr-:m=F/z(f~o	
ЙWeDfFIqU4u_
vD2
h_>?)JR	ECq'!B"y*y<y^;¾^wNIʳ]#L:+ݺN0U'?>?@z5pA1P,U JT;=}x'DVeuMRGOo"D~ݸ2QMxx257턧p3[y~H~6:~Clz:s~x0h2]O|(})	=~*idcOQjhr>n}6zr(1V?R_
izh)ԉl]7+O,i]*S
\lf336URj;'*	k8*QDsJM'~H7&cmvvJ	/,<zj-
J9y`}]epyO^ m?@8X
Y8,X)չVK2T+xHOó
?9cM]WJvynq^|޾#Ռ>Mƻ1OtJ!آ'V9.,<v2߳qόIMn~^>vaye3e.׬9fk?*ݏǗWD&ETPCf~pӛTB̽g/.nr3[9Qa2:CE:`$l!BvO133=^&9y_{o̉-}J
i;9>Bs)	U'^﯅_/mOD1R~yTeugΐ!oxYݟyxOG87Sw	hu.ŞE_/~|s|Т@[ ,~/YX!,_Bl]/ņllф̃i3'bGaqqpJ܇yʹЇP[Fa6CwNO! R1=>K_<2W7)5kiü{
$jG<V߉%G}HpBv0ͽ<LvD~8}	Q?gXvJ4'mDS*P*J@{\ߞv]AFPE7ͽWO#3w>_b1"T68@.|	 V|p}>.i-D+u&"v]@
Hcp&y#0oІ}@:,>ȝBHmFbo19q2}il'85T]+\hHCf6Hk>JCG7V ~!|OYO4oMJ;>옟8ȥ/#J\Kqn
گ#Ї@)#*}_S?qSПa([ʓ/ޡQ.̆az |eLKՈ-1/)<[^XǼ>3DgdaJ]T][1P<40xމ`$A4E#?99IIFO=#r C3=-;xqHF<[D"!@lr$[EoՃᬮ'3 @C		\Hyui}ۻ>z`b@8=
0'&&~^yB~^ՐO")PǵK.:D_np@vڙ-0z'L50h`gc!R#Nkq|'%	w*MURDhD2(S8fQ|>K??^m1I*[pOB2qH,

prT)eB?a@6`(yX(|μ0x0ZTt -~#BJ֗G-GVVR䃁V a;SJ@uE8HxSfO;h9gGd񐧴SD_}vgvxOB
ēj=W
wݎO7'$OU
N8&'*Cں2$XYُYھB8SD-E(r9O+Gǯ&l=Yzxa$֔fXCL|BDcd b	nP**?Ǔ>% YK{mz!IxיMR66O~˵eqMΪ91dF_[`?ӺnyxEF/W#y"݄+/M/EP='zu:J\#vJ	rMExĸy\`t!6թ[̑02ɮhsM8/?n?(|C
NAR5AK
&K*B/WRֈL)B|@M(`$(}Q1_Gg"BAT{*i9vr>I
D4cD`r2bBdzӖ8na4aC_Δ2l ISuR /-?m&*EI_1bxUo2*Oe'{/NӪ?tx9/+ԔiC! p	k>m=)EY!V,<*eΤ4*}hh=۳맙c{xy&vfB
N2XTX߯:<ŗ[l-UɸC񊪯l.ҋ(G><<VSawG"(Ex]oΛ_}fdՍ'S"drɃ[Oon90wN\*k\d6ukkeJvCp/{rJK[

BFޥN2/2Y,c	"{?xZf7<{qh-moΊNDXm9Uludlslwgۯ+e:۳sz69ÆzF+ɑ (*nW=\f z$Szׅ:BCǝ}Qd^=[UKMuF,("q(Cr~R,C9*>|#q§wIm+PVe	P]b $1  `X\nM|սj?0	N>3EfM	4W^l1_3A c6ꎈ9o1&	6eC-cJ vŢDXЕPt|S$%	lDV'Vy<ɶZ (NO OaL2A0T';q1:Ӆ}k򇖷;CXj}~ؠ:'`qr9&ZH^iI׎t//ꪪ           H                 {/wډXoR
)M5wQi⬓F$McZTUUUq}&{)a~4|JESS{>zr91R$$%!\1U}`(I
+Wh*
vaXC}U{

t㨮3"vLx-NmhGͯ8bD#|31-ӯ?d$-(#oA[^~[걫4fuMU~+5*K*IXR,!Y
BOϬ7iKf#s&&xA(P!z~E?3A,W큟ώ[!E*Yg繎TS?V0qk_9wIC'$RA%۸sfRGB75**
Ml*wR4@Һ!;;}RbVVkRMe&KW*Lť+۩Y[ΦFڌ$Az@	o7l0P;qp|̸3KCqL(!вր["%f,ȗjTِi-!61Ep S?4hHJ&CC+OQQa]2
?V`$]Uz4k 7,0od<hI猦!Y"Z1)1ulXaabAAitEJ(]6\95Y
(RZ:6aьDu-֩#TG&hRзM-&N3ڀ` iΆ!櫌""j@cM1)!Fah0۱GtJ:R}A2TNXkqFe)EY
8JL	a!2qe
M$4DCFBлb@@Sa׽b8~ċ"[1sL^ORUN1EEQ@EQQS|MQQQQ1EL37LbIQS3((y=ڕ{civvJ7~D?/*Â>.9$ԛ[[@s8wT5><|Ϸ5'q!Ǉq  H'x(V,`ɍ݋׾ǡ57>\;I
@|r@-"TN!q?>OQ,ґx?7n^Ci\n x8vO<z4A+%,hgwN0a`*$+]~&;wt%p2
TR@Tӏ
|>vxEG(g'q,Sv({`awtwa>ņb#a:3QSC~|κ%i`0swM̉[Tqg@NZ3Hq;ņfThQSO>/I;*x|xEOQQQQQSxRzEEEEEEEOoNwrgψSp%gWr;i0vn$l]vjgD,'QVG"qm~5?e	PpSA9
ڄ?jx,%'t|9O]کٿq衒Y
Gg?O#A=ɫ$0Rp-AqY|?D76"늻_ vy1a.$	LIS㓥ʌ(񼜍"5?H{.54$<#ce@b+/btՖ1ԎXb~# QZ]]_q.oCZ*oE2 +T*Z#CөdDD3FB67]

wejrq#PܑrS	lnR'6Q :|dd(~É:" {C6]XWdCq2xxKȏH{'xYw<Je)4R-h:lI#! ;F
eTwLX9 Hce!r/.6M/Ծyfؙ54jß?MS?Iؿ<t3{<XӏM3^8]cG0x*}=<ϧ{v_}`ܐJͲg
հ bl|lM؆;ς^TM
_d NցXld?*؀YxuB!*跣>7oOuon~>:<
ц0Fi}
]Ƕ({yj=چHhkS%c|9lEP!LY{̈Pvиh{sQ z@=@,LpB9bDucdx!NUX$ϝ#Y5M.lțI:j99,io6͹*C[%Cu#Lx٤
uCvYa߱oo<K6$Elfq9^g;bI:Qm3d8֋WDz"bn84rD{aH&l'NRӫ]GxQ~>!qm'.q4҂E9MJ)2aR!訖"0E,9p`CytAb*5S~{JjUYJ"d©ˬQ;syɍ}XCXIK5 j"m'+ǡ5N	\")EVEfbq|rHnNml.ٹ(Rq (hnyn'),f:&m;{&B-]إהI 	$-W͚CQ63]2ԛ֔FCMc7eUU"2/1S Bc$tТiϴyerziCDx%a v6t8m6$%6wazTbMX!9v_P04	28aX35;QtUFF#}h5O7m:mHUzccFF4$vf97_oA#\p\'L=ƼK_$OBA;hv
uJ^ᙹUTЃaG+$<{aV9SøM((ܐ
.(2e1!-!HZx>ӠBac?s>D>Ϟݳ}3df{\}Ĳ_L!R2|ЕQod$	}1~l}ث;n;
-P1O~O㿽;
|r-˝5e.oK\R{jw?ӈIZLI*I:I%)%	$$TdIZE$KI$JLI,E$JdIRII)I(I%	$$$$$RNIRII%iI,A$KǏSh}O:_c6/qCʇ!tKGя-ؿv,.%es@3?D?
UUmRTۂ sD)D@3O6ʷ_9	wlu@:;!͹˹а]r|:eQEQDxYxd
aU?XۍoVbIDmRT6&Ж?>pYOisJ@C}^|C]X^&(kC|
wUROg,~AbvՇ@w|')$"@$TPRId$I&Hs d=ghnp
}
*UѪ(NS+@B_P*X
E`~5?֝TuvtcZ*`=m?ĹMU-pQEPP/68>xL~{ͻݙ!4J"0K?"?>ۄ܄B#t&ڟC?<]>|'輍 E
"0Fiꇇ
};QEQ`s̛r*"Q7N!tg|>Uj>yvHct/C"u@HFEUG,ONO9ϯx~S碫FUUCI`2jGK,w3oGU;D!x!ZUxF? ?Qv;9??b"2ZU :q@>!Ųzf^|*h8ccgN>Lw[	wIczYXA-2/ >*މS΁$7y`1UB#$ @~2VTH$G+EU1D4<j+b#~9 2(zln_'zfW=e?~R1NB Rh8lMR*>?Z;7DA󒨦Ǝ^~SLOvag\$7COeUҨCRyzŊ6Ϧÿn*-+)OA<m{/6PgL(|</_콈z[_HT;q<rɿ#y"j(}?,`C\pӲ"vN`|ipTd== A@1g9 脥oW㞻_o
,(D?V˩2OSW['Nz:t%t~舞N:"'_E:wQ7Nvv]2tDtDny)R/ֹƩRҥND軫i僅aE[~D3׈wc4|<&>
	Q%wpHB!o f2 ȄԤ;xjtvvo
>VF~o/"*6uvóқLyh$9oO qEGuk4Fbvu@KAR?Nϭ>_Bg}tBҲzp82PCUͷIdNn԰C~)jZ

BnA@;nOW'i< n>Na
V6% xPWYP<9{YwG~_3RI$mnږ([ZawmUu~fg;4H3@=Yg\UUz`	/@./ڕLqXy1F=EԢ'liCp{hҞvLKv_pR
ĳ@m|W3d_+fUwf]`&*~m2I0 7u?]?'i;O*(pg%BjQN[-MR (*lWKv"$Ȕ҃gKbY&ldtw@i AuW\.|4~	;Nߞ8s?:RL-T,2H{@#<{0Q\pP\/hBVSxU@A,ym	J'x(<
_L+{^0rŁPSNHv\dK5(Қ%~1Y}\v;(44=fj;zm3f;d3FI<WPYT$ǛseXFwFxHLTʓB%ޞi|<L*l_t4_Øu
O'
i=) ޞSFag@.ܓOЎn:w_AHQFBPI3?T2n͉T[waڧؽ
g;QV4>| "T
p6 ,ְX,Gd`84j@W2`C0ԢT7k[ӎ؜!N]C|.d͒}j?@,DH5;?oB]bo{C4Ue74`pɟmY	:2=BP?^m4D$l2$?}zA962#N3^6 DpúK*z=rfORa,L
wD!CRr3#C#MYkJt-Q;wp4*|vp٠WT>砛T<0B~#TCX"t>TU4za=;u@nƸ/ky:ȑ5':T@Nz˥J~ۆQRQ4\ݬ~|w^EPAwuzВpDIbO^̽sVhd4K5=H"Wyo/zf#-{|:4y=
'^6i77$NJ:J]nຑ%˪YKH
|KKZ-?MsS׭Jp]Q"H' p:˕oP¡hjB&Ą#!8Sɶ1`h
O).	G+ib` b]7%-2C.wγ0UQV.ޢzIt
ɛ}|!ѧ1>xyϤ|sW;AG&	vڄQPlKVjșj9H_k,H$`Z{*w <t2q&vB_gj|ǴSf0ѐCy?c-O[XE+#UU*8:?d: l"|ܴ.ŲpjB좡Q-5nhjSLL߃(Y~3n8@CDÛ3CfL! 3;!EA.	oH|7_ m&zp<	&{]z[=ţZۢI6kL.S{ j-f{ߥVVc2([Ȉore$Ai's7.إoP>ZI쏱W"]菈~6{RdDGOSe1.\PJO׏vy&<+=s}gτ1v	^N(ӒmpѴ6㿧w#DDDD"Q:0RELB(y0;3mϳE~
	 =M)1>
hp0* O򈁈']NIPS.:>^(/-Bת'GJQ㒇kL"|L&3IT<]!Iz:s8A}wKj$MفMF0
*|r|3cӉ/{"1U\_2CfH A HXJGT_ : Bt$O08TJ~m,`m7>\%2;UP+/؈pg@dƯNaEy9N!"C\%e?5iL9v߳Na9Iܱq2]☉R(df>oU5-0?GksAz
D(h6W_;,=aX\u
Pxhjqrϥ}uzY[~}lM3Β(F_ZJR0)[~D>aO&8JYK0,ம  當9 [YbH
hTX[q,q]1Mt,SU`u1#i
cQh* QMS􊐉㰇
&']Ϟ]b9ׁcO`/
!3Hg %xW4?vN80w7?$z/|\̀rexsjǋ]gb!XAt=M+C0vj|OZ=ukunT%c>6QzzwYHT3TI'nkMTs/D4@8|I$uBN	~uBhJ5' G߂<N}˦xx\ꓳ!a'R|ǺS|!SC_&]:۬Iym%Zd@;d|?aߊLPTdHv#=,|;Nnn(d
2!A8\bc0dKsI)\eʻ{5%K7WjKyJSn)b1ٚZSPU}G.:N[]`2~?ISe{> "'mMZY4G;
Cu
vO1\ R'3oV$ʯx}
~hec"e\ͧ?mԵ:!{'*^0R`G tӡ)
l[la`LqdA8:͠pLdg]tE>D)飞~#a|[Eↄ(T:	
2mD}Q/ؼ& +|@Kf?s˖ONAɲŜUcKL+K}>l|gWatSd11T[g{giu'gm#hY!@F\xm@j@*9
"'<}>U"8*Pޝf"~iSj5
!a"/0JET|+zxWCog\67"H,N!_ rrKhm&rgX!ä7og"%ND'wױ4T*Hx|xxY[!no?D?6A7WҌ^ 3(%ХۘJ{ZFCܰAAbQkp<	ي{~g]f{UCqg8PzVTʑ^3$vG'"9>`.I$"yy>=|e$uAe/iXL<ܕgT~_FRI8EHxB+AѰ(V}a3v$tڄ&9г]h9UqF@qq4Ɔu
äMByY%xcdNjq_Vtɇ˫X~ء(0(qpC)*@sFJGʙo[V즁^sGgtWe$۰9)M
8>ﳟ?+S'w>yxŴ+wba	D
qfxW{gN__ _Q8Cڄ<-FDA}VYO L!$| !6>XFI)d
fB\HH#'	^f5`:FMS$S<{ccX*3z<0{r#LBF	UFH`)
f?{&1~f8%^B"|NU2ؒ^-ż;ffB$$bZ()7E`Θ%0t Ucn!8 qP1Wr+SƬdW:j9^ȷfUfUUUUj:AAe4$۰m8T<s>19&c}$!)מ۸+V!ۿS5c:s匽Cbqm7+UR<KSP LdM?dwǪo'oG_gbjw?4<J
@3$d)BcT_*tGh'%jIOفGg+gk.MXDGM1ۧ;W	#v9ܔ /ʯ]MUS(:cOC6x~E
FΔ@GttYQO30hw!FYN}疸C_b|ҲwP0&86Vi8A'"EYӦd{=&Rb=74xXeػEqs|g,7lmh2s`G'>A4ʟx
~o	Ja9B>wΠs9|_ˁ[4GUYWQvXBr0-wus@ۍ,t$q/NɎّl"O_m^:&g8go߶^gZeϫ|~-CDov<%GgjB~inE(p|4sqxA=s{wEC4,N5$-	T&գ""H3#pn;utڲ+2`K:ꎜo2EBPe,Vz_&K ut-7rrH>:I+CbL=m)Ș(0GUĒDPA`!_QB?.`v&SD+tj!
Bj B>\B+a 	̍ -_D`
ī h!F91HCjѣc!CwL=Id`g-Lq3t@"@ap@|޲wvnerF8)d`]gVǠ$y07)TUd61j}1)i{In(B,iYJhp_`{R
 F>/$)A0\Ed˩z$e!*Z+YISg; w$!VӰ9>P!tt)H'ە4?$7^TJp`aW"R_s홆+ا̥Ah /a)Ub^iu\o_+#X1r#D}@UPeCm^:.Q$>ܰ\8h*Ȉ&8IU2w:=Sqt]hCn5OӍ׾{!R:DE2ѹx:$F%*Yaf(R%>o]W=>]t?Wjxf58t#YRnBOFI=rRhKANɪ'S0NOW	t 읛P$l~!lp߼MK^dABHUܳrem}&OXT8*!.	df[~?p$-eTc"yPD)֌Sh } 	gѲK `Hn` ǆD@S	chBT1UUbZZςxX6uP8vcya" H	]M5+X?.<KHf˓H3ӛ 2	fx:?΅/KcJy`c t  GB*O/WnNpWb4c @'o3M&P:`9կ|n1
}p@R,lvkE'TE6?CH([P%'k,f EF\i	CQ6z$STD.[é,֗H\=?Q<0O.򴢣U]L㐇Got"+d@jf(QD5_o*Cb{ b@Cg01Sw[%Fhگ-hFEM*ŤٶJRr {><ó1SjT" qBR^W}^ˑAU ePk6,qv,4>5^#3
9U@i0fd}Z!HhX¶2"X`H<>dH	~l?jgRdSBJ71݆m\36`hFk*-?7="%r}0옊0f)!U?׵ z {C	A$ }Wd=E*J  F`b?Hmb닮Gȶ	(3;h~,֧(:, C12TC0ݼm<pN:lt;_i>(mDsT}GߘΟۑ-gE5	aX2gq :Ozc=(Ϙ>5BKU\cҿLR ~tO\do;G^_W3QW~Q
4ޟ|a<-5M>39D[m+WO+:"Hq?0 |L@p ))!w~h5PFËSKF!x4 	}	wO,M~9Qy՗+Y>xc58aEҊ~ݙvPݲ_(t
!)HHႇ/!%8PJ(k0O<)շaQ4IJEQeX|]JwvbTZ'm$!9ɒ``V*gk=4ZAd+dHP0$4IHA1>G;TJWhpHT5(:%HbT,34ֈ{du j5"83TM[VۗsvE\E*ZK6[2ZT%w`&%!
k$CiT\ާ)ܟ埕dw&XS`=[Zd佶fo/WXD?}&^m+Pcpin f

$Rɞg%>f]3.j]D71Qu$lY[ G\"]Ηk! =>:_۶J\^νC\Y+S國kY
$a&Hfw0h*2m)d)4SJ\R,4.؆K @P0dAiÌ0䬟d '}_ΰ'U;eԞ" J*ZU\s3mHW\T
TÍH;AtG<a(Miۇ75;fSȴ3E HsMvzVڻ`S߸7!ڛN7pK5Έ&KNK6iѥ7
TĒM`Lt')W;A0*߃9X+ZA U1
d!ZYB]&S/{|tu]G2(!;4#/]Tzc;EqqM>"zj9v4sNcD}#)BBG1?<>A+цda=ZQ$ 20SZ
A7ÀEEߒ2p}vLE+,GKXޕ>004\Xwx*9_^8yė?v^k_SEM |?UUUUUs-;9o p󜯷Yv3C:<BzPj2k}>w~Ǿ}}۩O8f	[GTNpz{{DȒO:=Oe~UU@    b Ɗ@    (  0   @ ufDt'nQ=fj4oi 2NJ;;iEٵ10/?';2
M`javg6dcԢ;Lyӹu$62^^)!s';$OshLĒ:&)tl>L3*o?H
	woy)1i'nA%1cx/[b^6Me&Ex"UPb7
؉PXh4uqWkf 9wы:UPL*6N|`8 hw3ǩɾ~fňx
"b"Iabݗ-=ܼ
!8wA%`r
؎lrMɨíMB/`v-9|m$M?girMԺ.ÜN!k=7&{Uy
Jl29cC^)/՚
ﭼEm\WY*<J*ד(4UUM>׶={~U                                                               _c~{Xyŷ("Ԕt>+!;0sB*F8K*tE,-=J%9w|XwlNEqM5=*8SbZl5^NCTwIo$:-rct:~#&"iɟ:CІЈbOdNd=?[g2R׷?haf2
~#4qYU	TD27Hh(Lp
@SAKnTݴRD?$2qNxwf*>zM0@)NQ
0nD76%J!"$U@lہ8W6wZX@o.µ^ަ~}^eWubx1aIc4a!A[1йr&(W.L){f	H\dDb#TH@U5%QI9FV[`Q`82#]WMʜ/r
Aig5ZEC(.4 O+Q(3ɧ[O=|H;L"sSjDW4F(^1D!0>)Dk]'
{~yqqzl>;Ϯ~eJXFwJ-}!PC`'B61%)Kԫ
 PR~
˪֨~a;@YZy구$ fy^zYTcF	/JRTX4b)JG Pfocj||OLnp͢xt>L*P_EǬ{JmBhNO_g〱֜6U#C+

}'5O
~%1=Db"{liJOZ~gky[Sxσ<Nn9WH?~'loeivHTq~FU Aj7)X H_Ug|oK(ɷCd҃:U?ܲPJCUfImdOo鉢[~:=glC˙|E%~P`~r?^[}_sIxzK$-&8<1+t~zQ՛=aU/љe!GpuU?0=kjl%	RY/8|-7{2X7^o_1I+II%I'I$$$$tJLI+HIb	$IZ	I%IZLI*I:I%)%	$$$$PJRII*I2I$"I%$I%zle*|%˷FVF@X2ٝ]wwwwittǉƛ/f߲xqإN?jO|t?2zp7؄!=Bs^LCK)-%EbM)G|Bdm\Xʺf*e}9azMeNeX`f$bJ\5T˻	Du#%[jMtV:yTЊg2mgL3hMғѦ2
VF4$2hI4^JfsUor®2tfRBX{Xuwp
j<W2n|Cpl^T=1@=tW}:m,Wsއ l~vnz@ǦD 2N<k巧pi<|8"ݝ[-^Bu1'!0<+)Ǽ'&Cyxa<>M~.˥p'Sݱyj'E^u:)ʚ|yT>aru-Ax0xc
Ӕ*
r+
8Ѝl(fyx6HO?	s3Kd4BeIѼnf[ޜgyf{H6	4[~S=Q1>DbfpON~9\4?yJ2Ÿ+N$bK!'8[P;`LOUI\L7Bًja+M^%Ӣa,
Ռh0~&]ds}jyFyhfN%yvxHF޾"azeݢ|)0-`vS2|}}o[1[-a_3Z:%<@ȢIsQ"oCIC30yӸW݉y_~>{PHG?& >?:Yqooc`zM?TyTAY%;GzҐ}5w[#t>AtkuCOy`&W^I?{g\	E6ߠgþl_oA)TϢdQCGωD%חQ'6ȪO?2zo8~r)JվG/_\O]g\L Y0OFGnکC>Ii]۷O\O}f]6SeUo~ANu--3(!))<qgPJ"̗Iz|Ȼ}?^:-sL$!|*zw0Vgl
s8h0lI"MeQ`yxpxd:?:{"z;Mnxݣ)=/ھl>,vLRjLؖ7B*^~J ,r,<R%U7|$i	5"Eb?Jp&}}_/N,:9$_dHOg7lP{UV
/gO0_rh7Ad潔<	OY?=<P(/**TϳӥM扚kbB<2>gR&McJ
٠fv,SOKڭ=hU:i3|m>c<Ιk.oƊe8*Kv"
)
^ CT^|-i	 ,X|e O$VgF64*'>L
n>h6mޡ)!->D}0/*)xq;ћc,{L}NOpض}I*:i#~uaьa)Rϰ=Bת7Dt4}皜|w}]<H[*IqT
I'tzqMg M%왿n4ܓ BbyDo&s\9ЋBB
r"Q|z^*AeyIE5*4_@}M׸x==^	VIN5:L̫iu;;z7̓fw³N"09	׌cڋIz=w9GrfmÍ6OM^Q$:!_=s;T鯆W8:aȻ3D1-k=)N>+iwBbEG~0߳ٷf[#]pRF+St}P'"jXl.FXU)(ɠw{Wcd^⩊dLzǇNlh۳MYKhxcV?'Ə&y!.:n!ON,;so7c紐?[m|{6abbcv<޾uفxcKWVh%*-K<wGuܣݜvڝfrƊ^Dۣo8+v}pmz_|Ӕ/Nv>aΣ:IbQD^5+yyo|2-Y颰Ǒvn O*MeRtChݟQst崢3f'lXhlYj2o_OKgLTstNۮRb>9_l<I$_KqզWo{nС
*eQmצץ6ȖmWss;;$nEjHڙ9ެ0y~mE$JdIRII)I(I%	$$$$J)$XI$VdIb)$V$JNIJIBI(I%)%I'I$$$$tJLI+HIb	$IwS=Q_SEumﷄRoOeGUJ,=E^2ݓƣ/Q!2Y/H"*|۸MxBqE}kcÎ/[ztY	
0҆ϋ$a62uR{ӛ^lmAJz]FP8F	`IN;:uEwUyMUr}Y3⩢͛e/ϻK鵩__}] c]˔^]vy2660q=c51XڵצVv'z[+W;yiIrػZ[^t/9S҄'%O)5췅hjɱ:cnECdJQVH7Nt-ǐ|3zb'İ	>S;IO82	DzqO هHo>>o~Oޤ d P	xD?yY`bdPYkeKMhR̩Q*ƔhڨB!dwl
S#"Z6TZ/b溴04kX@KJD"D
o"q(4	A$f7RbZcJJ|-(I 0{RKWK[&ZR-&5RZ64iQOԮW`QGYZ	F&d;1H$OXG"5 lu:YQ$SJTPZD1GT(~ >/d!MH<&D7b=7EE:'|=͊
}w؀Of!$D
A&H$G\"y>PC!)`5cn0Vui4l[I!)jDQj*uWl3!Yr""H0S%_LBl'VAD,lЫ#@m 6CJBL04rZ
U2V. 4á5<g|2ɈN2a J!ȂgSkЄ?{FP!{ϤG?+~sD@>'~wwg,c<<TÈ{KKfa5C
ft|1븾Cѥ\v\yw,%4''TUۑZ8e_&Ni8"rD6C!N&}#>{%f.\hAQ%͕p tpHuq΃`ԍ2YQh@©'zLX2f{MF x#j[Á&lT		C7_G?̿j(~WzWp!>	?)uUB~k<}|q-O#.X1g[X$Hѻ˰}'uwR:MÞ;E
"3i̫RHXǝLA!>x%LD3D?I/X ?S${F	
Bl읳''GdIvhm@9sA7Sd'*zc7N|MAN9D `Loamu}M2ds˟>Q(s Nʪ(20I}sI'T8#RX"2*oE'M*;";2$F7)AqDAW
YuZLY!$1Ϥw_R]yo@(aE*&΃Td @,U#bBdLby/DL.`ZlB
]/53yɅ$6h"$RjUPQ7C-T0!~SeOSX|Bъ3,_5ےhB!:Q1A
!VD+lU{yznHyoW+bMԂ>("ws#tJvf|,y<nn)O%"60]3?OPp*;<!)svsNQY}^X>BJ:VB3Juղ\NJysʌ*?
mK['Q<
"}+I$~ͽM(*>ҙcÎB/.ZtX'Ҽ4I>PT %rse y{2k?_j{z{=״(>?6`d >6OT.Vg=To) N_1?ק:;(C,"N"wٜ^S/-1?^]c'Gj
@ =(d1߄lV!HDI0AbX$B?
KZIiɤ(@\p	2P0cDhC˰ ~egy}E=V}Yw~7
y
8(2dh.3p`e0̌
̥
a\f
d R"ZX!&ҔL)aJY1kL4aMJi`ęAD]!]4)`BM6携T0CCD¥Z
)iنؕ)60YEA0qL0Y0
4ؘ-)i1Q5hRF@34M,LtdҁJaC4f8i34IavۦBeK&M6޵I.ҢXTKDracID)DS0G
3M40L44(hnM0lʉiAJdrK&K[in)L,))D"]h
0¦4s0Fɦd	`
aiv²WF2DA)˔FDJTPS
le""\%6Aц0JX333
DVQR<?F=@lSX*	(TK!Fo45ɞ=uk		BD,O"&,dBizB:'R_=SdTepu_?|" 8ZWi<M(q<̓YzM>_`UOv2!`%_S1F%u⾍?|cñ=s8!BwwwwwMͻ뻛wwww]wwwn黻}>ϳwwtۻww7wwM7wwwwMͻuۻlOOגLoۻNmcOpT\Άkg4iCܟ-=i)=)A0c(~wy{}F~v`#1<~<[;Z[qGT,֗kEv)g:|4xgEa
x_j/1Ca<Zfw[{38΋ȈD­uD^*(Ɂ̇Z]&"mI=q|)vFҔ&E=§3"wL|HD"?g'{&I$$$Qo{{$$J)$XI$_(!u~tt?ϋ+1I+t$7u)'PJR_ۍsԀ`0]XPts
|zǟ`%0ـ1.઄$pǎyFhYk[YkJ@-gZ{ZӭuڜaaLkZֶ6Qf|td;5q{$_CDWۛjEQEFjMISW*5mARj5&jMwvѩ* tք$ڤj5XZwVV]RT*-EmjJXѹ1bجحIRTZ*]Rj-ZQ%F
ڹj6ZbV+Qt%QhZMQjKRZԚFFQԚFQVJQh"	Hf`J2@a0TP[u\h[Pw7OI<qXR@>r?fC~T>_Y۰}p@9 
՘oi,$	pPr[>As<spC[ebI:U~ߧ8f>pXGW
.JOVԖd.DF
h5sTIRXq~ ́Ej-E`9J&"1]qNbZ#F}*A;u9/Z}Ѐ")3Kp0ԏ.sg~*-?y7zHZ~a~JO<8	] J7<x`uZvGџ{XQCl8QME' A=Pa]?/y`@B>s<s;a}TT<{=QvJr#]>%1VI9dXG@(}EDJaBf)oaqUD$~DK)vz<H&>ù;
TT#7;Qyǳn\+3<$(ڋ/AmG2N\Ӓ㊾d@@@=Jb4{C~h<B{v&9j Lx"I#9.'Z=.Fh7w=]Ճw㦤U1?-mR0a_fniE
e؊04OTbaͽׂvT``!񀪲VC΁&q	Pu˄S >8q"lIPh=w@v.'CxĐH v!42NBrpObцB
;YF=5+$ #[*(ÏJA:,Iu] zg)I}$ǻ,!fk±OSqD+J>AO4 
\ 37

=
)HFCueo 
<T<;	:kJSֶ> >O7gg:5
%YlTR<ƀ!>z*' ۴f$EYI~l3]bG	-:kWH%EP	Eh^dĀd Jg=.obvX?Y6zwm_.$®!Ҵ2??}Dx>%B
¶^G)	˯pp>rx!4;㱕v9AIyuA*:m9ȍ(f0;
Cfgt0U Ȃk0;w
$`nރʒӕ
ke4ĭ1"$GwfN؀u r*Y1 tb6VQӁ.;'NpS
4$k}V:Av!h	y2 VT B[{qG^a&!$DFt7f7GewLI4&"ޚ0A  a48pG"9&^iChW?ӇTXT(fGwӜA&Z4HPӞy juD/l6)7mT	iW.I:dhp@r@S*&U^ 
RSp׷ C{l\Q>a)'?Dg9!ʉՇjw5lcc &Bv0C.x+˺ۏS|TGA~'L`=9c(	pL6,yO@caLFG>!J>z}םvղ}Q,5+)w2-^W7|[;V˜	Y6XL{plrr6WE8k0G;S0jmſӥgL5rY1),鿤M
5y~~bDn{3	nk:/oQh6,Rjh	AH<o~S
5ά?yto	i9rE
Oτ;ZԼc|0@rKa"teQD@ s 8I fw/ 
ӷń;.G1)EPX9jI7EQ>p`wwO:@N8=mV>E^^;`5 S5)Jz^QU9>mq5#ezm5UM҄{	بLӂω,KfX-)GSaqS,}^ؙխ؏K[<Wpָ, "l̘_~
>|,~I[v:)Q+,D:UMu W3i`=)%Xng0	FD#ثeUi;{L۵}w;%fUUQ :.K@A	k]5a ˇs " $ smgH3
 42h鳴NkNv(%7Qq˻;H8F 	xRD؎cܽN&!CCi+0H9p9M=@>ohp$@P_!&tJDrǏt|ECd! " <CC;' z>OG?a肠&(`r>3iY(&ړmF YS2lZJKhQ@\h}OLQzFn
"G0) 

)jО?tk6kE݉T+z`.Ԡ`ǸteHH HX:[Rhb$@hșP-?YaEHRJN*?7Ll.2@JR$4!ZL̐
WPlb1[q+TmD<m6؍n	,Jdd)@T9dQJT]zwpt]m@fH91B73*0p%h$$fXQ-ˁ]Ѧ8PW.d-=Z7Rk5(`Q{}mtj
ɇ@v9@1tD0MR`)ITkFTD%YC-6Y1!q6TEA$E
;[Y49s^RQWwzO_[=iSd	JKgW<X1fp<ۂgM3ALJԲJU4Y)""!=搱
ljyɆhRXiŉ	I,ֺWi&-+LHHYrK^|䬔||A:NXjZzޏ#_˾qol5ERgw#@~"Y
aJ?)h8X<E|߾|ü"Qx. g
?,G 
ABadC5pM?Y9MDU9?x91 "h%@{ؤE%+{&WMB>]ڄ!ЊHP(mW5-ZHD,@U<#A>=Ob鿦5C׋o>KVk14#*8T|3\5盠L "M:<b(?@sDUD)YLItKw/N~nB{dIųخ9n')rSH-kl
_y\~g|wK4ƐRێQEPFU.Zbs_w?߳n̠}hy	JBz+g$'|*HgPU4͎DD߆y6;vyZkVfk]QQ|pe0QqЈđNtNtO>E(P;e>0t⳿߯RL̒\knB9pZcJ
r)_
x1
:R``TJ#qxǁp|Tr ai|-?){QcTd#LBwn($1Qv1wwK3Ra4A`\1q
^u_"83$a\<N΄@T٦$HIe)AȋD{fޢRo79EHΙ1N&kL޵p)lh,G5A.)$RўֵZkZ@&. 
s>>'_Asyyi2IcZ`Bֵ<<ԂEA2P-)Х_(3(	( "%cfAZoN2NB/`hpә?
4d8ۂ9m,5Ƶ$dy%y|iSci&0}pl(/'oa4Xt5Md)m:5A#Fe-No\Κcg,;l6*
řRvyO&l	Bi>if̽4K2c͛ͽucRut
gsIaک	z14X5VڈpZ\LUMnLͩ6+~fFЯLH7iklHҿ Wnh
"yQ |{gբ׮2'حff{y5$Ǘ3FvqN ÉDٱ
TwXEfݚeN,SDPļ9YUfZ3'2+."fb..dNA̋VZf^2333&݋S@LC&bhUTU6fffe=ݼQi9epU\ff]]MAy^5Msv7wuf⩪D&dag5X1SX^.f%.,M5^aiyFLIj,7n	MV[	bĳvgl;fgwK%7,H.bp5M9WKUǑOym2!"[3	Ox-MQjxm=>XǩgYUef>em5e$y˻̶B$x"ff*,%ĆsW9g'+//f3i@a-uw7F;1yYvn]ټxj55rheDg,&fDU02c*a7uEq5Wy"&f"<Q˫w&`s"f]݃U@ӎNu8.Ls"5GUsTi6Mv&t5vHSf!3%23g/UWyfs5Wyff[<6Ne,5W@ĳUccǻ̶y񕗂$SU[H,5x2)FX,&>V).-E<eeඈZjx&gYjxy{Yjx&wYZcLfffffffffffdDUW,5x<M^Wh̼gʺix,5yxMygne4e\eee&
aȦ͓Uĵ^YVͭ]]4ٌV%TgHMvi$i$bllHrdh ԵNzQxElio2o&&'P-qUrr(Di6%c;Ak'6ԁ@z\7Qzi0P680Xl7Hsd9Yd,5zmcΆ9JNi)ډK?{*,-r#"+/.3'(IikèjuYɫjɇg/Wrb"d5f[heaɺxcxwg"g*0ݜxww0Yvj2Qa&nx<i
* Sm9wwl 5ߢԱ.L4Ziݜ̱qF8I3U
-
TP(銆":*"ya$4qmo֫jLk+A餟~@'XL(iT-]J6ym{L<$S/SZ4'z|x{ߨ)¡߯u}z*4:_slG= @ߞD4eVy}Jb"/^;,R+ ޟqlӵ%bNviħ@K
{rzu0*ï>G(	<\ADe\SME&Μ!r 2.6n]qɿI$FR3@ [;zh$q>cLD!E|{tLRizö0Ӯ'=C$Y#;v<3]BP6%T'Mx+,$dҸ'b[$t	N!Gm*cm0w%jUQED	./;M):CKf
^B&) +I)}5$%wB"92`Fq{y~!FJBj.j6SP'SdDUZ8:xwm$Ó:PXoЯ\sn oLqǤ:hU\lKh
]
0  ڞ{ hSTÛz:uG
 kkFm}=(5HQKH8 9e2hM1׃&.bjZ36+j30lǓAx@3;
JJZ$jTb92][Lז.&,ȫf&y2"
!GAs\Lk-mlղz\0BMFDJTItBtr)5\qVmz@iQ;읔u-$#(:e
#[-8f,h,3I]oh(yoaC(|Mu$-̵>o/m)S@HdXǸvfQ2 z9^6 1A3h!G']3+iU!^nINmᶭK
VI{woH,T75ͳCQ+`k"nDPh!x^lgL;jXo`38u	 cdS=߅NKh.sWZ/!HhC2plrl OiA6FQ7ibN4h 9bI!Kt4<
,7'$xB5`^*薈 U),
*URIE3
NR\Y1)'#8ۑ VP\$RC
 azS\ٵ[31b<9pxade$8SD&Rrf[s:	UtDIe4hDqVˀH5s5ldc^}?I檵o; D8qm5oP19׍u<h40Pn=0	hrJ0`h0V ugmUZfsv7-`uɌLL1ΏełV٤a3XN
A/Q,r-p<( rw3*URj;^|bۋ17j`ц;/isx&43$a@f5WСGt<XDEQDeTƘcf9L&"۶wL|\͋dIKggȎ>}X
b}Ppjx#L:-w C{~θ@ZI<?*Za<vfXhaҨ@3{Rn>ΗI\5I uK1Ӟ]q=yMl,>6u/@GI {@~?eTtjesX0>(Y18^;o7;%g;+:$Dڷ6&L,L8s:ZVI^j73߳}¤ѰmB&-|(4aL&V0H5؈e3NVpeo.L^OcpJa~8Po"m
~NfPU2O P ~ ;J'R
u[Ha3PE; 
Y&:A]
K7E%'ī1Wʘ{a%T%SLFY1s+IL̒V/!fG3;aE4hny	+m*n}I'wtƿ_pfF)`.NÌܩX iT3paK(tlpxzּx[놏
-?FaOt=k$90:){48(:IsC.G"Hb5c_@$|?o
׎Eyɲ ّP#ԘAΠ|6;
:%q6Ö!OqgHt";pG) :imׄ 57֪d_"Pc6O鬜vkTúDǯ֧[+@A/X>q8(.bKPKcݣoj?wڿ1= u	!OiS?T»7!yHVJ5xY
3 /IaH?<į7
ϝ6%-{ho;gg}t eAp5ݿ=a?qpgi
V1Ƭ0[1y4WQ,*k&ݭ\puGk[tuMS>UݝZ,
0e65#
w7?LW~;I'7'9P/[
+ͧ+Z
cCCm~&֧6Z8Kqw8Z?c?y~/@7kCt@aT;]qot	Аf>Æ[x H)xۥeM3:m!!Ҫ
ud!#.]4),6m@r&%(&^æٗw˧[nG@a$s7 jϙCǟgfY}&bb(ξ=|9t&	ƈ)EQ(O	Jt8ݷ{e0ْ1ruѼUbcxN5#6PDQ)E=y{{N{/pۨ&A
'%eu|TA6R,J?V)?|}j wh>m5ݦǇ^u3dqUHcaPݖSk-Ʊ {%rڿ=uَkpQRȀpT5A(SslTyPxxwVۍdܵXjnJsmyA0dP+)wy_.&s,/ݩ({Cv0p,AlH)%$ES%246.sCx7
Ef06JʔPuxɃlid2Uba͛i2T0PՐ#(4ejuSFc; &gC68:c:oȤLƱ1aոr6Kh*FOI'H`#$ws22N/"
>J2\Q8|dWwEPq@ҥo'_i"#nU1|_^~[=x_! L&	)Mddd)*R!R>N6EbV#J50iC*=n |)ϲ?WjݒRc-ձύO~xJ.#yZmxKsϜt޽Q_K߆_%ɸb'
+ĆKOaEu~BC].̿ɉ
E[I+ҤE@AE;pf/Ti'F?:O1''8HhH2NmI۽aHdɐ?ݺ5My+vlLs|i#EUO;^;޼+JkVfk[#D1P r?0u6c>?/TS>
u^][mkֵâ-P8j
#\ʅM&fp|iY~+I(pxǎVZkZ)JՑEsYx5!~/'	jd́qam.E{
F68ۙs}$BQdJ6H6+%J)(H	L!<
o${.[K{y*Vֶ%$3t dkXǏxqy%e搆a"+Yn}`9χN~n7u9D|a7
G4cz=x𮱗T$S>>o5]WV'x8߳s{7eA]vB)X! [,fns4M3;ѽf7!0`idqoNk>def("bs*x/C/hrqZv2zI=ʱxJkŔXɇq"ϓ3EBxQ1T-L=Sx3^"r*ճNѐ$"YlO	34JΆ- ? i I(~+E#d~kůԙHAc9ew*XV
6Q@
]6lTMկ
V
M	1㴢(lڲlp0Ʀ:GZLJ}pMl
3nt)mΦp0G\zD 4]H,66OlF D:xy:}:90]/8GN(#3!}#zDt|7wꧧgM4 lc\8P|5l!_{T'
d3/CPB7Y(]hXٗ0ʅ|re( >NSe '!
O<xo$ilnO;aֹv{h9CӉi&7?Ou%_:63XP~,W~
4Px3-9 >Oy fr6͐/n&v@r?BNceTƥ0*р{y{sھ{b) >&\fg΃)h :;PBgۋ.Val3^ۤv7d#67dxQ ue(cԀtNOi{Sa{|܊	n^gtug
8tol5V"ۙO";g/&O1[V=C[2ɕ
ٖL;㑷@dCnNxe@yN؀PPA3m:\	UA4<<b]]69cE '*{j`BNI<r}ݹwiF0YxLYjeC<ѓE
5y46թi99@ݐ6"ȈP2	+׺*V}%%6kw"tvo>:9x,!~gd9N5,SrSB_U7=͸p}E$X:Y_GP
u@_ۋϧwB{Αq
 F
'Ry<1iÙzSr3+5g/A!ec257%%]WE׋yֺyU͙F1kT/᪓ݨ| fEBU%02NW]M.cw+2C.f\lL[>n:pV!@vE}\q=1rƶ7r]́5[)a߹mo<35#$|y|th;08T
y?̗烈)"KXøt	(r!0!E#pJw*ײi4azCv$w"ozݤN#G
ӁzFСM
('.pr*Yv"v~?O]ӂzR&1ڒ&GlxDmTc@VӖX?s(!8񊕴CTBDST<ΜֵjխjŐ0A, wbba}קͶSD7B,	A{CQ穽'%q֩JBfI"VQ'dF _cwThO&=YVgCϷ|B<ί}'g/wh3VI\s1K\H*clp	KVZEuιA@t{51RaHnܲx<WwKDMSuE0l^ti)G|	uߌu35{9:.o
g,&c$Q<1e !x|Lpbj"_T
ͩJߜʤ}bzWѤ/7E=:KIv|!(FNPq1"w"*>D.cbU6&>5kXֵrb/x>4{2NG	/)Ǜ'3 8 k/5b	.{5<Xd@)VfEb	/sCK[
 ACa&b+l7FS$]mIh7qxv?'>y>%@=U1f.ʳV{ַZ$P;$1+Z-k`䆁8]<O>b}y~}s`9ODϲ+$~IQI>_w{@Y$&y^M6Bdlvh?ξGbQWi<KKD=A"$E3K&kIS-l:4Ԭk-UC&SdE&g,Rj嫩Eff32F-6)"
%O9v՗)-1-kH
4u.?'1
[ 8µrQVK G|MI?4nԟguGʍJx:Ah=	">47>Wo	E[ATԬ+ѱ" r̸MK~}uw+ݖ@mf\oۼ黓ok25O/QQzst>;ۏ?q
+23`>l2(z'Wvl ]K Ӽ2vɷu~2mcS6CE::4vW禹;|zxwq{wyj biU`y}qG=ti`
5QWS;Vp 3Zg.N6loc7&ܒMy$O$)agJ8Tl}5NEw *(9ΈAaf97W:m&:{dXj1q̬[̮$׍akŠNeH+NpƕY~2j	Ŵx:Mji
nm
b5M-V)(.YLpowy"=T]#CLkG-W[lxQQj&Q\'	`,< Z&0"Hۓ*
ɺ=1akn-H 

Y
.Ft:*1엡M|~/~339
3CGx" @azYc.JU֋7KvY*r@" hB^C3;DOf+i
Q~[PҢ|6?cџ9PшPzO<ẩ9lx{82,$HI(q֞ ╉(n-ֱkYk[D7y/yFP_?if
6ɢnF!J,ЬЛUhщڥGk/_(EXI TI{7V9rkZՙZ U}wpEWvo#z}p4G(aGA:~A䜉D@i"F;c"*6-mzt|;h Ywyr͎"~_	`e9ϩ]}ȗ$7o=n.<t$t\ xA=i|41]+xghOz5iMD'Εk/%7#psGcIg4;-5ϝ}P^o\y#,uKߏ󏻯w~SQeNG\:?6tmD3e(hn$$&shEGsI1VWV״izq&6ΫtwV+ZkZ}uA7i4VmM4ҳV{ֵCvS]ǝzeq6}z"vpVh:3F0<:rD~v~j k9#PajtRRY,%m6ɲi4LM	9%1D<gncVUZ{Z܆(ώ+8aV*Zx0Q[gAa=rD!ZJJR kBTZ|ڬ)ofV)S&^RăTUd$9+/Aɖ{JLZ)b˫֪⼄..XcA$"3JU*SgM^)fjSٓ%P&(,8%%Ge][3b[Z@Ko=t1HZP@Xt,'-XT 'Pm
idPhf@cjۙ~=Lsxl>tqXۮ*.#s㎱ٶ^ww&PjUBBHBB=ٰk\UIc|qu<bD D	)Eu{n?<>_T{|?^"DkxXP9ΧЅNswpIxsp)KimTUDETm>z>㐄wz<cm\XyJ!cyb/oon,J).ܥ,s1޽^  IÙ'lYy뿏$@XIAU)s{*wx3)mm!BXSG+s2UUUsse^D2woE _|H$KϗUUEk]_IhRcFInoחmtqRT U			$^|oP8wJ;<qr"C1$#7mݗwA_
e/HBHBܯ}]`jU*,]62)ZTnY:-|-EDDTTk[<<N<:WMЧ#o؇~yw~ pAB_oI$@_բŘAU`
sÌc**\Ds&rR
yD)m[Bfu6b3-ٖJֶw{Z6}sVIEBLt_e:ۯ]᢫馚VjխkꌲndDɢ!TQzVpІ'9,$li=_A\Ɉό|h1D3X^r^RMU槝
c\R{T
@g\MTϰxeu,3?;{>%ǯ.͵ߦMƟ:;=|vs;T6⇠0o2)uVbgC@dxbJ2
FA(C#Ůeq8&ݗ8qGOegDv5<]z)x}aQ.!!0?BEAgJ)?އ?f*I2wkZvZָ؃醰ATDU=^@'8Jj^o.]$րHo"5ucZD2>~^{)$kA:kZ$q{⒵mE)#)
=kQE$Yût%@"̠5"j<ֈ"JoP|ruXҵ+KJ4a1$	uL&bŬ/M+1*{$iU\$&+Zqp^MA(/QXxYxxTT;QWm$x|9x<|P̶fė;=BI^WUMIFK?\"E
KNw3[iʓz'.W'2V`DTPlr_D]c	Sd1ǤzU\0ugRR[m)m)U[p|:pq+­ j34":f??l $>|7}PDe CDzKF$7WߞfpgAII$DTVr^t|n׷x'lF=2iYVm] Gnۘ~}n!)l/KZ[Kim"""+}G8K@CX\o;Y=C~Ur@3>RI?]{$7γhU*۹wkHFfffk;BB@$\ $MV3٪'(:Bwwy^y}@$DM\m:j&j:5f^FٙOvQP I!^qvkY5w_篺-Km 	˝Pӌ9vg#GF02;r֩8ĞMFz6h፶r;=%EPϷփ`Dt_~inpPI$@3RW|/I32IL࠲Lvc*UpZD2(*;$o;)L>K+{ݣҒIQ<_yԄbxqhK-¦6T3Ve}!H[ko./^4ut1
8?o83Ef>Әk!3\Oca맓OϵgY99+Gv{upæS?\[]&Pn<I%/.c.ʵUfDc>!e1ELk֬\kZ5/, q^sڏ<ߊRL̽I` y@o2%a&F2dW6ͣvm1$b""""MmJDE$DDIZMsn˖:mΕoo3^y>/$.o{{JjwkZSzMEFKgwfX!dƫ2w|GHH$4yw
~9ȺL;bhvSm/<#uVV;׊༽U&**UX-c,DC3R M574+
4ZvlW%W**RǓ6C%r*{|=_!$
h_,T)+;y;JRCl9gU1"Jk}1˗-Q
GNǟ_|rBuUWq$	zy{_N͜%]` U*)4Wc}~?Ԑ BI%\+qV9sn߳I٭bG}$$$	z~9"kr+YM<hjۙ=RREEF:[jw'm5[^YNg_̺-gyQU $Ho롇LW&׵p $A$E #vY; m~%5G=tI'}I I$DEEUVk]&N[ڸx=?/珓-a$ ` hE+dȳڧ:LÝ BH</F`VUV<9mAU@*q>ncC³
eK*b3GwC˖UZ{ZcUs=ˊ*cD}I$%z,K0$QAAQLyvu&ʵSzIHfQN~׵H:`43<0~>Tt廷  NI|dGB;=mx{[
i=vqz=<=٩yn|~վW~oio`ұF5dDF]0.hοum3Ĺ/UPyI9cl;֬[ZִJ;C*]Pfd,@}k_ 'Dws](I32]{CZe@ofC 4yyt3${JRMs`!@D0tFta.f6ʻFŲ4XUՍ@D4g&BTk5mVo`YhD%Uc)aV&nd*QW+&,V˴47U9/JիjUxXx4eݦt
3gde35_ HBG̾y)wyJC=2/O4碍%QWF"A	QgVGhuO
{_
Ylqp"ӹB VQ\X'EA  Ɔ)©FfFrM*+݁vR׳S?-NUZ
U|Q5Qo.DuCAŦ"I3E ?D~Ìh7DNϙHͭ@}¯RpX~	3ZU,a֝lVf	\-}B=bA-yvvl/Ư06!sf1#ZxN5uJP! <
6m$l|Ԛ]%3.*5D_m&i}fN5a8	ffk+6@,$ 
`ۣ*0Jȟ^nT%*9g0:[_n@1f{-Xֵfj쵭m}iTo~ &XG1}I32IP:!oiI$"1$#o#o__M}w^Pg8Dxhw+GWU=}ɘ44-]bўyn1`}.Uߝ|k/{79zxO	*`h3u>w~om7,ǯ㏜  C,??HՇvFWYД|aJO]+5Ұjuc?gs$+A?]uӤ%?zI'뮺q:I]o|ClBI+ 5ST $2 BBaƵ.:2IK{:sI32]o{f23N`t%`3	Msku5?Cxs|/9vd$r]ջR̅#NSS<U=,M6JIa^\&b"2b7MV9ҬMK%iZp!UIc3U⢲o6BaJ*BW
fqakhκ~w=_g]
s5aI6cxZiYg~ieǙ|v+el	ab}V
k@׋vOI,36D$RkPuΎл#*>3ߔCFxv!ŷ4xUg!M4&2[eJ4\H=37ClU Cefm
"*cV!*!
նߏ%^&0x^ז4[5ᢪmQ)vtXݕUU[+1 +~s]MT&seh͚-;.SHS'lNvԎ}{&\NuxTL2:hMJ+.;`aZՙ[ZP[yVs$fd<t~~_,݁/y4#ՉJ賎cH P\گ#
0
(҃8ILVJ.LeST(O,*ll/s'>su-js=λ;*>wmc[G7f7ǒ%^߷ƫZf2$I-sYQ2̚SklixAgO=Rʈ_AoY񆛸M
M*G\U'U2;/ʓ×=cL|xF& /tE*UЄ#ÞMz֬Zvks*&{Z7Hkȇ?\})VfjֵkZ&n%T3pGF:}	Bggg{7d3$}nFK	 C  {{oxIIuLgӤ%2̇w~hoZG-Oa!8xF1,BpL15~!es5tyԣLG;r5CT:u%UZ!]"əJ|eY4̴&2ҡf$OtmUsJ-5,THlW%WYSQ1$f+3FYԵaz k&QWaUrPnyk%sΗu2';pW/x^\]WYbv"׺S]&\ԊA<[
VJӞUUsVǥ!lqKuBy- (jĢάl٬LUU^vcjÆ%`4EDx	v^j`ׂ аTUU]Ze+KID6 #MDcV g d  lׅ7w}ʽelw ,rffLBAƮKW`ML25G{CHALUD@_*.xF20dٟeVxUU9h$28 '1=*P^*pSt$Y_AF1omX~"j͙LդD˼
8$gx$>ubOuJT	۪y  W@
:\5ho0d<gղm֚k\Opc\ȒbI$I)޳uNfdy?]u$L̒^͈`7x dU|i>{2ϯUU"8<I]Kpk=A0f:bHwƦ]wб-yy6ko7Y?+A$}oD
p{Ͻϔ|2rQ`VWΞ̱A羼Ώ'gq{]E|7'^oq{UĸOWӟ*ybe$\\	&(ۿKa	N5Y `3LJWd3$tk};dV$$a9si2IKA Yք9}Qa$ID1,VJ)6 @4A yuxIJZII+d3$| >>0;-o|{>Ny&ݥS3͉Jս͊ÈS⸊WcVN^S'gx{jOk&)dLŒUxWuxըxYJD=[d*U,fjP&3ڼO%RD2ր_=,\u:޿3
x4@j]78~c]t6rp[y#3?fi"I>րrWy)~In]j(4[UZ+i B8TZZЄ(mcgk+H	ӆġlF	[:ꪬeףh	Y,D.9$z$j*V;=wkd= (ZR25wRWW{2\j BFtcЄ!*hdUQl
WvvT0U/!HY
"dF7SAIa3ikh{U~I32I}m
?8%flT d3b	']'bMUfyS@a̓<ZQnͿ]ByKb&S[9D|Q0tٓG\9LGgPyqBo;|67NM:VB#D;Lϩ
yqny̌r:#飯U{QLtEE oO%SK:',=dv溜m|
h<tkP(^Nِ&YIQ"[MClS%Ƹ,RJEJ@#JƥONA@2$%[gI,wzW!\ahG=ɨ-u6kc%ШJptuQwqUv˻/ѻ~{O{06ѻdF~n]mQbjl{}dC}z
?_z2>
M<?<x Ꮬz~d'w_d6UU(*w& 7'/(MxQf^%_')N0=ǷsC_햊EgٛvW#$_h31u=YG!!"!"!HR!HRw'0{)>gbe4މ)dv;^ony*FFD:&=(Ar~㯗W+.$zNJ7D\
ÀG@_-b\wLoϳ6?
Ap
TToA>'N3zWx;)
^nw}[d'JHA:sU/_IPN~ٙm}f,oșdDUBvDs#<buR-p&_tD_/3xx2'wD~LG CG< פ,ky	S4	)A7*'X
b"׏j) ix8iSMC_OURuw^T?#{(Ri	rQxСlo@YU=ѤӳyW*W${ij4'MQE_-{w}D=]&AQ;A'R~XM|F(LB@bP&F__	P;D:UO_LBD'?	$Ct%=Qg(XW@rb$ Eҭf	'n贛cxEDz&\8;vܺ
~Iv'BJO"S[0_?GtnqtKD7v+\2HY&M$YO[Q? "7Qx]R,K~
K0܆*}W)5zQE7/d[wJ#ϩeeeG(]%w06н	!awvu<F<X?`1an/?O^Fڽ]ʋv)=,F1;[z~#է+>
JCCAg1PDL׏TNJsCpcI<Oj.OEN2,Q
SsbBS2d>fө0-QUXȁK|E~_@@LVK4ETUCRÒ;ِ,/Q|;Qzߓ"HUߪi${&ٰ}\oMHOz?z~_׼<׷u72""~P2Oq#m&qPNT曼bBж&.[_6t9G
ڣ.5=Q{XqO;{|^D't9xFXm!%Sҩܡ5Vۖz|vܮCb0P抬T6܍P+0Q/KDG{~f }L!:KǺ3؏aCGі7rh8ʑח}j'lb},	!VHNF*f.*дDQ#6Ci22*QU&o&-i;9acFˬ|Q?c_#VGIR{!ЇM9Mtzcsa0[/C!PAL=B
M⒚Φ׊,#G`x6я{a:c@82)f(ó-Q]k̂^.2)NGE;HїQiق+')c#czY,}N4_PC'UR. O{8Wc&mxi}цjmS}1JK$Fx+^4<] @|*ww27**qTY|*cS,2KF3qCF)ۭXyЧR6l0{փ^Nx㹶/+>UPmkH"qS+0L*m5<Έ2vIT=fWu(ϯ6QP<&wX)۱L2`YTDڨMA\65o}^&b\d;/*k«in<jhqǮ͇~i(:
⊨c>do&Uk]vL7G./~n;%P+$ ^%l;tGD\G,!-i6C,

ZW\>^iesٮ|:S~Y5fRKby/_^7zen}G{U@݆C猟tۣҺW<IÔ	}caW.%>v
FJu)Q|t[L2EMmáVTC%tёf^ʾu7K(SϩᅶڨG𼝡׿9{3Xׄ}[
uϝK))uzEІ$G]	 cWSne`oMo`ENϣ-q
3>Ae$>
5ą4UCr?)U&4C	JP

,Y$H`OM =1֝t
9 1{?i6DUA<E1IDj DCje1갿շ)oIjEJ('b/#]G<s	6<'ÔP@LIj@;5:EO:l*7Pg6shG
%8)Sa-S?
Etkxz
ZqƎs֤>:y/	߭Cl|zr^IGeQ<ޓee%p5":{2bl*tX8˓[l ؇C4=" rj?i+uFQT\Gd0Lo7K໦nI|phqrcFSY~?ɭp!s>_oh=XPmQk7b/
 OW(~S
{/#\?-zJ2h6=Qb : KG5qQEa|@4@3
dHօjHI]#!!@$"1 >R-w.2~@ԸqKQe\U6Y޻)'Ud?}9
_);$)hx=p_#hf!!2JЊ4p!IxG#f5^I'Q)o*?&e<8h
.<j)ťM|0`Ss)dxbrjerC#%HHiCdxa϶A+ &*!*jbDS6HnUlkoɁ #pS"`ĉO*6Y	"VA	LzC(n+]Ե6K)Bʌ7N	CP,fEddәC"L1;I9`pY`!֙bjwu
rBԢv vHo	[^k`kU##CPjU&A2ys^%XٔSM#^
V/rֵ5WP@TDڨ!@C}Ă/6?G?a]GEC~Au)\g|Hh E	Uz	U

5F (EHu(-TDќK !3߯HoOuO?1SSKOQPW  bXf)>j!B(NP@6BI5Wfe3L6J@	|T>4Dp*">Z"8O! r@ +#ϩA?-:sᢰd?'Uނ
速<ՖҎ)3PT؝ zoB~]QBKAO~lfOzxy\-8TQf++N\=%#_̩$ x@?6?"l!}>iPqMT?[ȝkhO\%8p)A{9)DMtǰKAb<qJnfgrO*/ɁC*
T|^ᇒzCS@˯=[1W
49-B!ES@1-:;.9!P>^tt6qQ8zG-(nh6 qaDAF]JDf&(Yu6Q5~o0>S=@$"Bo#sq=n kSp!#TEvI32oT!ThC8c@f]hdGo6d:Cht?
_zv* (A
Mu֛PJ
C@x`t"^zk^QW 
$G'aΩcIE
N.g1
ll&)

xA[
Z#su b"#%PMV*,K	[imlo4o9bkD:xA%Z	pDإYDp=QZA)l;/uu)j'Z&S15NQR_2*`%g)jbŵJ)J1ke6{GID0}ԁӐDG'$=p5R~ҝ{ĂO>k?4GdW tLo*Ly .
>#X''!Z~LQj~_B/ޠqkWq.Bc#-'Lq"zOW\b}}LMC[Qt}\A?h;07}({{I
}\Lm;?!ǺP{XC/sgʪE=PJ%t':zz~8`A܌] S1ENS?+

CJAƌ !ET<Pΐ"@c=s32І>a@lpz
c_Hu1h'Q.Au"$iR	 };y!Bd0]b!?6x`a
f3EODQ&}`mc޹:T
㋺.aϸ
"|ߒIYfHO),;u矣}050QFx@Ѫy>=9.I9vOm^w~$
C۸n+~X[@/g<@Ms(E	-QPdI g䀒!83Z_-4'}z(A4E1w\Q.Xc8X9P_WPf
K-f<*ixr^%v
{C)+BKaT%{tq)=_','`x#aOaW UT<oV.NԿs`(h'^J<+R'6>s9q W`dS`4iAd}Y"	0[銥3ND.	Ynp4b蚹tۗM\m˦&ܸUʢ&1m5{9г@D&h2<i fI)X1&ii\c|G<^ZYx	?p~o?Gc3xQem`
t4@lS
x[.ph9\ ;\!V C-@w<j]MVėp<݃C`jnղ#n	J~ܖKbRt1.!69\YmאFV
`{2>I(|o~d#<L\]il{i	1TkZ07ݻ؟Cϵ6 tR%"r"<!g.#vi`++)\UUU=(]j ~!ʙ|*gtAzho_QlQ3`aZXP25jrhJ*#
:D,6E6{PcW-CE?wE8z߁&*Tw"rr b*mǙs_2[kOhs%]

¡~0<iUF!"U>TSRD $iIIؤtGN4',?$s@W! G Wtp
.@|§
<@K&)	Puf0wz*}]OC$I$IIRDtay`v @#]

.fAWuFQTmUUFQTmUUFQTmUUFQTmUR(J b	,"!@@DFA(A@E /d
h!l@\O"S2HER LTj(9SO0	Ȉ|#OM)#O |b#DD:ϺH<AHyR>E/ :Q϶	&["@U< ml"	%~p#0M%LiDq
ӢcX1{/y1C6
b8>x4.xn6)9})l/ZjUAP6hY/bgxںҥ ZݪB+uNo9,@DƗhBeB }4("hS*,oBQ
*"N@23飔E,ӖHFvd wF<!2AYES%"
S:
q
nǯ8}Qzj
(RNPܕ>?/M?I/|i"C! a>l?Q򘙠"B#=ȇ?Q"
}+)R6YXp?|nf:$}1vdaYv&yƛQi͚
"D.*fcp}dPLzK(6`,p& +Zc2LN,ˑu5	 58NN`yqq Z΄r H:yϳTZJv4>ZMa.C53Ԑ!g%Ҋ,/MbU1Ăx)3h~n?^&Dv)VBb![!%]YWNT<v7՜Qq) y9	S%4ׇl 8$E.
&CxBnGp>$FDը*`t0%$
SE -lmCQ<ӬNKVw%h"cԢN" d|>#mzf"a+@q?]F=@sMD1o\:)2A@;\_[XzPs.gr.҇݃NFocFPRmHl#u<	A(
)C;s:IDbk4FS")(I-]
;p7.ŦlXhp)AR{HFW?b2>RR1-@I­	B">A9:`U-C0
i
F
d,u:]5M0 S
!>8Z @I'N/}#ŇsQ@<
4QȡQ\ /Ɨ$dH902@FUߏ$JM	a&jz)Af 
(BD'2*$J<I85 	CPГP4DPRt.b6%hz)\#PLz1AO<L'uTf| R
>rCDvr tLlp`XH f8(4oPhkM$H}]Wb^H "JjD,R)P48`r)ZhqZv8H5E! Bag/{>~W7Xg2np2I aJII-!Ft?˯)"^
!Tu=! J@2 ( @l_ք G vB ?y0ŷ*$A㰐x&Aa&C<_)T7愂F@;AUZ~m,ы^CP(4gbȴiz͈/n*&dDHDC`7@q @iGL9%4*yaJW5W6xUD!#DB?␖0$ڲiKhAADDDZmzu&m8)ꏜqvy#E/4!C	]BDS*&9XtBx	Sz:1Ç%da+B8
 $Nw@UB4CJYZiC(PMTXJ]ɃJ@vMG\ R]^&B	 '?X~?¡%,ˋCD5K`H'pC~{>/PC,.K	u]~D
URUUzhzf`T! =FT2EQR_%܌"po?tB 5U1?mg*Թ{rU8C4i)j*]u
U?<R1ȡ!GY?(M88=򗵶]	"gPSǃ@\N[@޵	ɉ&pU	2Bvu u<Aq)@dֈxLyhM"QE\G!hd)5;Țn`Rt\ NνE8D1h>X'-$?>&<4DtX=++ktL=PCdO `	+ެdD*LAdC
8jF	(PJ9 A@^Y.֢1Ͱ0/?u)J	pqH7~4P=208U7|0,54ROvIԐ6zܦ8ze+;Axǣ|22iɨ}}XyY#)^~=a-QO# C_ܗAz/E#a2CUr^m_o0Q_DG}`@дCsoW6_, x:*q21D  p܌{;M5 >1k_KxR43gr܄dHIRB x]R	"0^'0l*sUq'|"}c*="E|+̂z#d Te4a@/H
cabX)	1r찹.KBK]eW.®]r.Eq!SP 	
*z`^b<u|B6xMSvHh?,Q?K>V?H![?_lDT#	=÷ A:5' 3=
W&`aht9@dM	J3t/W 	pue3k6ȅázbS;^I']puX>| 
p
P 
P

 D_U|XRB' #lRYhGh%gSMD7H݌Y :ѥHBPDpS!L}~׏vϠAjt 0&ꪅUUU/ytCcϼzˤMA
?I<Գ?#ނe[Pϴ2eo8A ~fVX@b%roAB쿴NO
| gCZinJ7m*_uЉ>~D' &_2,6Or{{9}fE%QMYUTQUNo>^l-Z<;ݚ0*eF-,45'9o_2	?'iKM}?yv:6*'(|nRcF]Wm΃4,Id*DA b5ո8Ө
݅lux ! 9	4 ,Y!eU"݅;0BpgZFD0LVZ%@,(":qoU	|ٛJRXmhJ rfF$6̚ؐ+M<l8hE2. _[WFFEfMH	:^=7y}1SB'	jyN8Zqr˓;8RE&+i:ExknA!ݹEU&WL
 MJ"vc%Qܐ;h9AUFݼ/~]"4nZjVb`8q(R$c&抦t:mՂ
z	` +(Zym'NjШ HBor
B8@4Mx\ Jq
$E餾="Q}P^Ud-z3P,ucM_@,V1=`RQ	Nn@WD`#1y!RS}X PT=&{]JiP:	Rg&PMW k٥w*J@&6JmMR+
b&RabB]18C_ٟv4̕CA*Cin#	A}]AXfJ/"񷆡. ~+-
4$
CZ]9:p#"i(QB nINz
T%i8ѻ'_6fi4'٦ˬUbR*U@c*J?A`C=å> 0 'w#.y΀#qX5sIYԉ(S<ځ7 /WP[o_<n*@O@!]6*0\Tp$ȎyzøH^ *-pBKk۩p@A֌s0T 8:G#x
ܸخ,inTUꥃMTr(jv!rB8

Dw7̦ƻ~*kXK(9	 cH)+PO{ rѩ|`ԕm6No/i*HHBW䁰gc\XQOE`/>Eoa;P
VфcX'--Kh)
	CuW3$^6 0 `Wp*.GFs$"SCn#L)R̀"Ͻ@qeБa |R;-td 5F7D\pB4bvFlR$I!4Ñ)8#;8T9$"nb2B pQ!	:t( 9$HQתtr) 6Pfm!G<zlX~AF# @B5Va|KxܽGUE7}2L}!1!XG6j`ߖ!u+HvtF4=B=Da(%,4  DC(shd5_s rh`	vaqÆ8w`: Ή;gJ}+`5<<1lb͛?65΂0A"0AJ X^30	@ubi+PؚnÌփ4"dDSA
phL!uo\; T8A89C$#4D}7C{6`R!8px8T-\"a
>ؤ0pT9':טiw4c8@D45Ϙ.1G<.vB7I&Fu&  "H;#<5"	PBj)NZ82 & Q^B9˹`Pb_Fbu!0JO^gXt)G<81[%J@g<1HU{@]"'PdΝԁ'>ihɛ,7,M{96 Q嬃=Güh=i|T&B{dتH!#SHE SLdJȥzhn'j=(UPeXi>w/~/yoz	!M2 k2m0  "{ʺ@=BJM4O|ۦ%.cdRPx4 sǉ7l&'}HRy0,lZ tP
K 9iRru P9
BiN{iOrȡ(?LvP/hʸ<J{J	*)
kzT<˛ˎX,
'b;ëByC(up%-Pl!4)q*l?@[Yg,ri'4m;N!,)
!c zU'3V`)
8ٌy.9AsIͲl	Nn5ƱIU']MaS.>_AI'wb0"-<NBM>`~Ni~%_QEG4+9}o|~m30Xwu[+$9$-;.Ҙ}b";pTwsY-0YM%тEC~ 8w	,,uDɬ´kC<"PZ
S7A곰M>hiMLC@LOC
uI$!Gj
	5
$?WE1[<Y@p`˥ Tl]`AVu +EC_bHR
gʲC!j=ga!REH"eaIDLG	ߗhL:S	
/>V4
T<G	FB\DWa7';"7 1݅M^(Z:j ǷCxZ:hjX$Pps
UWsrT9q´@(ЅJl>a@W
`gfM;: 	@FU&!؆Ŵ2 T 
E^(!4^e)*CQ*\!dPF/!
C
ET:@}/>o(|B@O[k=%Dvl.4
̐h234䞚
젬46;ά`@Zi=N$IՇ.4<Ǟzif2VMJj{psr}! HA95Bb(l(5=DߺߔVNӴ}ry?}ŶW[*E Y#K)0q@@=Yb%0$
ra-%Cb%Oi9 CO(Fɐ;(f郶@"Aw; GWP^^;WnFl4 .zUwOT0
&

RHE O(J<ń,ذh!9v1 ;hŲ&9C3Gy%
AiTb;eϴ

ǖ0/)x;ضIߒmkj{֎$Ҩ꠴l),ץٽ
8QTc]@Á
jD,6ÅEH+X3c:!#	pB' >%u*hw?+9%9ᦅhgΦCN{[R<У@PMd,IFi,^p!GG:Q<|
Q%Pn3pN_Xc~ L{Zا(5>t$	$
|::{9<0;"Bu{: @&-m&jW@t0+35CȷAOJֺ$D	OIrM)M3#t~B8ph$eO;1?O/>BPa}"bba&Oy2dɓ&$dk5ɓNtuuI2c1&LdۦLc&1d1b0I&Lս˥b.,2z]9tuߋ.)~s5Ғݎc1c=|oS]&1>
ғL12dݓ&L2udɓ%&Li:2dɓ&_Vcή'W=
~ŜAi4Q1)4]1R`Ѐ"΢)S`L:`1ƫDA(Μ`}ji=uל970<>n,8iǉf݉k.6Xhq#Tvԡ#(^履|$:އ;e&V]L~AM 7Nd-Ԥ]xc`a$&bq7n4%A%Kyȴ<Ss`nwp=wALcPK% ML!scG|$<UB	
D$^$#g@Ә' ,Q|ո0|Ns:Ev?y#l;Cg7"9սj!R(AVH	ۄ0Cg"pmodxİ,[Pn26i h{W%|&8CJ!Tܩ,8|,F,J4Y*(U{b`GiKg3"(HP!	:eF*8fF!Y:Sovt	
MlYn0BIcͱ)A@z*UUl
#5rWZD8мrKCr& hm
<&PzKN	vq
:MR8BǭہWيCږ<`z*n\ʠh-Z(v0bhM-E
g&	f>B B+$U黻2';Cr_Q)n鿻DC~,$]l`蚇JIt ?R~N(-=4j"zp 
vYY9>	TQb ý GB<FiZrQT+WD~oQ^CZD]= @"j]D6mxGˍ0m&JG^z/(bF5Kֲ뼿"%B0M{G H՚ISJ)jOqyQ}Bty~\;"u/O}¨})oPr	6k*3J>m>67'&(iG6h`:~/IESULIܚTfh`^I ֌RR ũl,!AA4P{$B$ 6` І'0GH|K ;<1(>N&Ðx
4iYo8JoD]b$,ɸȁ*idRz?JLSAj CByRJ@bzUU뷺	|v@ss       ss 9=[~{^B"&QXjjT;
5{JUOd1= DǕ{?QjQ߷>b7ި7@|%5P-Y,(
BVlCrЪPj/30 =`O %qá5ΆCjPBɠh">&VO+ㄣtM/+O
\aSs?(lH={Vx ɸjxi>׎?+#z
KQPxkΆD`:*`@@`}jb!2:)@т@[h- 0012Q4(46ְT\),REb >?7_=X
֫Q*q @86r^ NEr@E0 R飢##$ zЧ9^@
> ܱBR%0~CW'{{ojw  yLԀ] 9:Oη6Gim R쪪 VںI'e8-0ِ
|{wnRJ[I ~jMr@   :#$I7Z'Z/{y{Wp|zz|מ|~W	vWYS!N|
?AF~1ԭfG Pr1cZ nP;BB$ΔzF̓Q,e`Sg```EB=4/ يK٧(	eCv$U?/G0 &H,]??f_2T4k֍LUBzq^-pabGo>jNǢ_y\*Q$㔣?~=EL"T*-/cHYE-ySpbΧG8a9FLص:^2?˜aT?&E!<[41bwKw zfzo]ǿF^9'тe
69#v^?x`_)UwffuO~f& #12ݠXYEk7z*
IA2f$M3I5u e-8$I#
B{zffӾ!Jh)+38Shu 2H)[?Pj 2HEvjd>Cmh:$&kOGVs׎[M!
⠂ T3F$Y x>}:D8,iۑ/M(%hғ:

;lD`H<4O(L{)67ITCYl

Ut"]d>e
::___CaEBA5
##F*̐,FJvo"󹪽ϝ)n\pgߥiUI$$TtJRJIBI)I'I$$$I$ I$$XI$$RPJIJIRII)I(I%	$$$$J)$XI$_:)&imhRvz/EP (߬}2;@L[Z2(?;%N1 3`n"*OIٿ Tx导nzd
U~
]rRdS$6AAߘ{ZoǗl,x<3>ڰ(AT<bLW%:`?(82Rf7`_.zΟ20(|ᥰQVGUQK(U܎ q	 U@*5څ p~Uw8_70p?'	N
(H_wk7?YMS5%$R"ݗw9ٲ)³frTTbpud:/:ZJ'*G2t8մ=x8hQO
Oq*2	PiZ΢X;UUUy(*>D],K <vI;hwɫJh%dB~<v S@%D}LV
t{zyP	zJZ*Ax wXYHu4n+=+ܸdӰ@Ly}Cc$dxry)L'N<qc1D:F:-+UZMzG*&$vGfAm-F鷓I35C
NFmllSFU@?tN;ӘrO%L(ha /V\{7Н5'
/XT8ڳ܌>!>pҰ
A)y#
]yp]|7>[:%@YҊCř*|V}JrG$tp|[J2VP]4ןGOw2Ib K<
dNCr.mnl3]7E_w;XjPg~҅U)AniYQ)0G @"}]^r`alZ+ʁJ`LIژF1"zOCp~Czj(gkcV]˻<(wd^LIKzU6"^'Nr{Ӂc^ wh%qꕥ8P&=Fp/A3*3ṽ%Oiða5>A<Fi
 $b
	56wiD$7 kfNmv/n]9fv9:j炱zA1z1=H +\Mf̍:_=4`ehнpzNtPshg'C	8NPq8}WQtQŔ#
QUz'DHCn|S"DRIe68tR<#.kMB{eVfiU7i}
X-t
}f7
2;a%0%rkxSϗL^:^ci:*p<HC	*DI0 G+Xvvv˒xk$B1J!}x)NB&}!70NE9#C*
ۣqT탊fv oޏY"7\N'|z<$^uB(n'D5񔽃4x0Tࠪ"NתVڭ:ΫkZ+hZք;HAQ33@+b" `<YYTRĥCԖ	 09(40;Q@˩! "N@Mng	VX=_zxßU'D9L6$8uNutdf!y8nM;:M6Fn^Htz ⤅BVךEWA5
5˃v;$mD<M~,9s!4;8ޮѥӰ\6TO8~ D'`}ȵ5j`41WB|̾SL_Y	^S!0 NFagg^G7-3RwR2ܲ0P㖨Y44DLI],l"u NFױvK[Vf\! =  QYo93ݰi.᨞`/2/^<̓QNR&-3^Ʋ3q8"w@<>#c/5.J=;En|DCjzNB'U鎹7,u:뮼Mxi>A) Ew!
*;8DN+k"ݠ4t*-Z-[4=dmt;%?s5lCGa@ۮmdv`oIyReݺLSeΦ,86-/2L"
iϊq`(+d
7P*3#+( jU3c_Dɑ
6`qےD
x='"F|+9z|o2"rp a'{gvU_iz!:.Tw	Maɚ@C@ѱb:
pV&دOUdb*1W+<q傮	 8;O3VKI]ՕEװRʇV[
q%czsNG܃u弎\INJ]ADQMGvfUSoFj̫}Z׉/gZ"HUE' 
-B[YÝtv)1H͔#ZInv6YC@{ DoY:kRsGR۷^jG:wMq= UA<	o{)GtYMoN5ά > QUzrA"	r2C"Yנ{wW.'I8'4/ѩ;,	&3ԛzX(9uN:3TI)ɵP5p
|gң#@'ݙ=W?!tHO{ۧ4IJRRx6xg# WSa#7@s$CoS!\}qWV
%rL_NhGD'(H/-.Ỳ_[ӷS V	އIO#Ë>bC|3<ʪn"#d!`hsf&=Ƀbp1åDDQQ=; CN!v	;r@wLyӅTUD	<wʓA>SNDU:QzoK!d5H_R \MdH16;na2}͢CFYVf5)j(CI.l` SZv
K7vf:xLF~x%0MMl80(!JRx
$
NbiЦa 
Em?MƒH᱐?0$PP7{
	;IG2C}Pj/A8.V}E/߈t24ͷj?n=x}|//BEWrEQ]p&ɯʰ6%F(RhE!AM\(šp,HT&*V;1hqXqϷԠDE$
GКa(dI*$bb">^6ݶU<
	0j*"h/n8Tz7CFU\ 8ts
蚓UCaSr`=S8LD$nQTQ v׋
5`-EG]224-ƞ<n*̚]xCqg-P
`l:NPp7VEY/6n9.0E!Fϳz.F)pF7@$JRk/>|!)"J2" 1$Db" λvo{;A" <fS(#Qt9rDbTd287`Cҁ] 5L2Y
t9 lI^K
ře&q r2vPeM}`vu	>Ijزu%rVH'xdy㤗3INC9C?Cl"к=窡,+32Soqe;c"7 >A!M" KPVCdJQ|G9D(uWf7_(=QFH%6n8S<Y2PDx{\v9c+3"x]*ps:I%At'$Di\!y"n
qz0,*Ͷ=<wz^5F ({|z8Sn>ZEW x`	O<PTxsyġ9mS#H4C
|uETƳc}cihqp(#T^gqϔԣB)(wD8!c=kXR(dK~o,A!*~(̎"`167-DpWbu@2-a ylotD(.a
 b" M!"xgwzUøƳ^:48
l;!I ኮbN[e):)b^䇉D):ԥKbAvQ*AS\,jòCs\0yi!a;E!$cјF9D^oB3Ě0|'D$C;B /L-zvc;\iD;nϙWG><#5kVjXBs0&p=tY@1nsveA(]̽/v99^OJ]c0w:#d<d
9a89	`iJRm $$	"-0a0000m	W1}ucs,aǥqٳ$D]^W}ZqNg?kWz1p#Ȼ	" P7#z/Z `ہ,"oF3=w$bH;j&*;nG"2AaPJP-_Dfz}juGWALE"Ng9=2n|%*n p;|JGGJvw*4y! .=dߓoW$$I$3331$I$)$I$I$I$I$I$I$I$I,I$I$I$I$I$I$I I$I$I$I$I$I$I$I$Iu8`_C_ Z %͂=  S.m!$f&h4F$\ېA'~,냠tԴۊa|⛽)0aiW$4#E+ 6p`BRIځ2Cަg}FxJ)J/莀b:0;GðN\i`Cll樣A#x	ԡ(Sj-R{90TNXZ:w0+;Aa4l;eGC@itq6F&_Gru]:
'ANK04⌹!Yx2L'pK$em`TQ3BMAԁ#Tih3<! e|N HCG`E72'}\:fC)E*gL+!KL8N]Ē;'T{νNa=]МrM&iC<7	Vn^ҏ$`(
A!3yRQ}&ox	<i9Ni{ܦhdprsWi(ǃx.@i"dբpu+$UQb8UKۂowjk/[a.]Օ]`CqN1_"@xiE0)~Z0 09p& @*SFKX%fے]y^t[\5==yCJ0!V鮒S5lqkO)h:ʷޕbb	19:s{5fK|ډ!6,B8p/sd7DujZwEc'g|s Di	R.G!>;[jb<
"CVa
W6<#	C>hanx o]|Ya 
Y,dHJLdʱ
O#"`O: 
#8fXu@O YLt(M
cfD}|`}.8tӷJt&)I>(-2GS	(B>ɝP
%.]Ljx㛽7G?R|UAǾj&R8[13(pJT98r(0'dNu`pDGDάiF/4PxeW^4"X{w@B|
O};q-НkZYA@:4+QvxCF	qٶBueu[kD>̅D1dr!܎QXyH'Gshv GlYẀz!{"Q 1XP 0	IInYp0AHJyP+'37%E\.ٿ؞q&O֖t^y{=(9-oXH2*6DmRD9&3,d?8}>_?gSb@㗣Ie("a'/ !N;ZGIMNitzOa_<GV dfb omӤ- A$!GԑGyh^[=bXFfCDռrǖND`#˔d:3!v)u68!L
a8$Ybn[&xƢ)塗
羍.-))v%
`!xI%Ud́ \
RM+cm$DkA׺?ZLcZ4L𣆸U?9h?y_lU_7#lQsbct99OdPxb)C:B"'HhfzֿG)4F ?'_?'B|usW~q	O?}}	$OƎe%*Rhvfl OaE=Yw	!iMnI |ם2uPS1 PD!"CAkCdY?7V0\za@NAN)2+Ȇo|)aTcr&B-,hk42ap`CțhP,ڡ?ThTDa݀w(=&&,2w{]LeI<+`=PS@LP'<?6a#s
KX9Ua&N-P%	6!4S,nH"
3@@
t ||P2%9i$l6B&݆Dnæ&! }Qȭmq0ԥ(4@̈R"BK	BϬA I)!,٦ɳbQ
K"߼cL>o1U1aRRq82`~yJ>Bx,Ei6y
uO,n'>O0뺯RItK`|~iKLAq?$d
ʆ2H,b?B$h_ȟnҲUmuCCbh
 t!BIpr\F	pֻmˮ7q!	u2HeCR*8"`+ !Q9a%hLWT,Q5MAB;6Wy4ufp1a@dl$-V827JS+P2Hd'Tx'p1DA$MDf!a9ia6״Nn0 z-Sᰃ	=O!CaLd	fdD;U[\PWbG	hA5MSD3c#'k(DQzh!2G=F$i8?%HA"s
ellVL`uJ!D rr0OC"QH &K:Ga<!r6DHGIܚ	f-c=nN2:tCv6
#V	<WU)D5Cw6:GIӪDC!Ӈ&qUZy3h\p̚UCBu&gkZO<}j+>_M.!ǌ',dZӊCeWwy@E~h	'F6Rӱ[yOOUO88/zzR)_mR~)'y|R'5EȔ@ה5+`y ޞt _smShcXkQAn'?o#IOɋM\^;j	Ϋ&ӌH\^MsXS<sZO0'X߂C/?>X,hs礙e) 8!l<SL7\C	a8=>lÉj'42H#+*,:<rI'	aLUa?|oCǻm\vZP.jRl)uZ=iZn5@F{zqGZcGe }ͼ]tFQll&u6%,zγ>j㴜1쏆j&jzr1D>7:++me'ZyA*e}(ؒfŬ!80`B	`I$	BS #%EF&ɰ "xEa-$Q -y6vA9yӮt?Ch8PP/YQzP?Ӈ|C4xϗ|%ã
(Go:%̰܀twh|[oQdΛ,<qB'xA#E4jr&ji}WNX3?CYY30)(5G˙3J?p|m{.F_ {q_(zyG*|!P=֎HJυIT"@0 ,'0ʂU0$C룝b^gWv`Pp,CD!
oݘ|7UMW ;?}x%<?qǢh^4Dj0DfO_aςho0!h
gw*f**=3V+#$B4Da
"tO9i(G%w
҃cpb	 41.)+DD(1 R#s.Y!QKiEa~B<圖v74A5\'σR
L&(H@!av(1%qU\S[Ԋ(Xc'`	q	;ceGx
#i)%(={vWE*?Sc8a9a[\2<!{վyqQyWT{ߝuLG=s4DI"XuEp?6j/*il\5o+ɵ.Ѧ<횂y#c qWZWN]%M_$	D
"3N<!p<RHaj46(؅Dw"2vR9xՎxip$(3ہI*8"T10UPE\p(Ʒ)!G/!?>(='bw4	u#fE8(H`>rJ(l٬U/p!uU˩e	xuO
da|Jd<y:ߞ޿ϕǏ*)Usoױ9ӆLaz&5-$IsH@P	f;PzZtY{JHZ2-Xl)c%,eAKh;j֎e7}rwfaD$F)J[suϓq}^p-C
@!q}ZdA7"@"CPַZ^o K4ʨP@a@Ёvn@3	G#dP XY:Ț[b4P1e%&,0h!b9'SWB'0
LLnJLʛ̈́(hCbPle)}kQ' lrGk@l(Z';o΋haC7˙^!-QE-(XHXI!"`j@O,$DE)j$10a"1*barNj-ii1M@}?#O*iz=gЇe:)eВo7@S˝>S>9ds8q|g Va	2i}u3y6|&Ǘ	¤K+ִ3$CfcV+i2)+ЙcRnQT(.`2d/:e r-.YNKKB%viW*~ϮxrGshiX閡X5	J)bHkݻ`8O|[qxbR6$%8q/.^+Vexam8
^wX/<MvՖzǳ{HpQXA@A
KvB{
?,U}GaBFBPRS@wBaIo		0嵛 9O
Oq)܂q  .>%?fDPKHa,ac`aZٙuM+nݺlձhjfiX2*ca1dV4.
{4=z
D|uei)%.EtϷ:(t_ @߃scA$#̪*þRvEYa?F>2I񇩄IJ$}~?yr~nAHlnvn0#%Bo61:ҿD:A`?Lm% k#)_n9FLBPDE,/#o9
Z:c1ع؄<+_Cپ8ڌ5POY*5XU{81sBlA$Ik!RlWM]ni5I]'<4n:Qi#h=tFV>u[BӚMg{?Y$?B0DȾ'ĔiUm>tNy;n?iUMP-B* R*-),  D	SA@B̸8F"8CB 8# 8)	C"{4hO0w:s|xNRZaOɢKCϾ!܏ wQ샶c";2SG:^$d&"Cj9*jqTO,xL$kř,i[*Z5BȓAswvj9TF(j>:m81!6މ}6-ͧ\Q"J&գ8HMPb+HLd.dfFO1CDBm(m(ui
NuU[\բ]v;<A-=NEß*[b$`z㨢`6\6hvb7^>/B(љKh1$;;1c	%=+YN;[m5E%%&L'dۄː^=6xP;
Qn4G|	vБvZhpMB$cnKRb'Z !>߷>QaV;-j%^Ph
^gf*9H<W琨YbWiu hgHTğ!8:ᭈm%CIocԎGX4L!Q=
l4F	R!8t`C$W@h8G5#ǎwJZģc(BEjd3]|3L!ȇAۿs.]fc!=|y!g) aNlq\le
ڈ&dxA+دRu cM	s5O'
@2KKgNCSs1'3htXtsBl33;:
Ė
@7n2>$!gj̝wumlp4ôv)urKix9"D:5)f뙗|=(:2Sik8%eW 0R6H؃H,J<nCѰ;y8RcãGV
⑛5FD5K/֝~pn3~g.	!:o\m
u|&Lү
/D)xCg'i\Qʄߙ"h;og(\06@58A;Z֛I(vD%-֥2iiuC[ML@@4oJN8uL#|{.SeT
71{wluk8ZQܴ][9]o쳓e!I{sϡNKoW9-3/ZРFS#aA</m0:g1I3h0ٕ;:YmrjH'8̛"$4~t)MD存T/Yۍ=N(b1L;BrtqMCF dĨ2#Su5wDRP@2-!r:A '5JbN] X8 $RsKm2ͳ  Le-`b7ca10Y&:sHA5{g5P;
ߍ=DWHR$
U2ͩleeXhC |ޘH 0#3a)W
4\XdRj6ۘ%W n8-r)AZX;td4RCӰQp6j~	&WLaOhOo_5T1 p
WqOD?WW߃Xibٜbp=IrL{T!y5JV9c='"agVQbWBCGqodB2ADP 	
JKTy JȉJRn]FVk;GA5H\2`6XD?o	2p$ugA7=I||{qYq4!)%ZILYk"T
ݜ
oç19?(@\  0/I=~ J$wN|wԯt%"X0
*-ϡײOh!PMFY

uйh:3U1o6
٧#*!6]=T3<A=X4wx,(z~4%Y%+֍x7k!ުkbNInxf4Tzw,	mEBùdvB%RGIr7úbFAڲX dJ$aP	kLK$CPqDG
:!F9!(f-`#H|=4:v y8)ѯ7>3D0s4dld, ;Q;G8a6%zh
̈́B
y'nșs*iI雧>4Խ^0
J5!hk@pL \!TZBh@MaAJABq
Yv4Exd۸LnbN ũp[?¿S^PxG~rC!a=)YN!x$='R#~*Y8RpD$[T2n*(jhgzg
atms0Kz.rIhbD7_&SR:SE%$\b%Ĕ!
.pt}
aЇ&B-'d//yi/
2]~2gv̲tuf=s؆"vX/6 )5/ɛ\_<PSTa
 !0xE&@4

ǟ~hvɯr1)zN:#rFzq6a<;T<=L҄M	/	 f9`ľZpL"	H$fh&jՖɪ (` 9rRiHR #㏸xb;)&a1PmZ`vM&PJS *
>
@fx]hT_iGWwyFy<ER:S0deQ2_FY&&8b&.8ιj"yJPbK	t<䩿9/7A@m1hBNF٩SZ;M}ۉb?Gc(SqRvD:~1${pc6Hmj5F^j+Dc+׿kCi/-kUlaig[	ҏ. I I  @"딗z&t
ePdr-ЀYˁi59'9t
\H[~L|سH	1e,XN'C^ D;zmm1]-	4	6"D-0&N-ܞxr|<'?S@[YN%D>CYȾx
|N GottQ	!"v7;f|(ҳO~?ݶ;7E*fgN]g|
0WYo[].3ғ3[Fu.b#dH>"f?<0iV P~KV~[BmUٱDپHwvvag2˄	l[WwA%Rλ1S31s@hC(eI=Iĝv{4Tg:ܥx-<|;aBu2ޔք!릗H֏Ms&o	h9i7)XiŢ)=T`|RJ*;A	uIB9%)ftcDHn-p0r64(.jJӋ ۝G4 U޳@
ML$V6jjnMG)Ή{׶QXL׎[ezOmy9aA8ؠQҩ@u:aCLaP̤cp!P2q4بC}{`]	:xoTEmv|A| Qz{PV֝AZ"#QHzZeILY")EB)8dLiQ'*`&7yw@*Mu  X	w9SSuA
!VtAF%N&fԳ3}D9o (dFF5 MFƣbب-EJ-J@`K!uvZ\X(raj.2s\$ݹ]ǣS,`^9v D1IMJP0 ,V9 D IW3|B)rjY0]
a2Zt'ER Yd͋H1xiqƻlN˧x!ֳ&LEYPIȺADZ
K/q; \0iz<櫹/BME:pH<%e	 *2m)gH	"R4t'$  iPut-8g^[U=
HA~kpD*4E},s2K
j,2
DC"9$dW
M
%	
I4!hPvJH&DoB'lacMv29EXmj ѐ@l[8JI@v$]ݲQ­!<cH`Hk!h2U#`AK;ŐFNֲ83C>R.ޭ
0$P<3SD{kk]ڝ̣FJ`SDpn5xl
.O"܎VdZҠ5z}}F
t0ӁBsCvThUj`#uҵuqBI1g)ϓ[xt`	Z62 #
b81;;RLf%;Խ	-
@Q"FR"*T#M	cJȱBb=2;$0h۴;
`3}8iaXpG85`ΧOLSA:}SA	uTȮ6Z%r%{
8)06]<^==^oe^x䧝d+`CsXùqm$*mjNrn^[<3-" d[hlς7l'Ќ|TnXTtɬr<l巒(6NDuc
S723{u}ǎ(h_AlvfŢ-D.zn[C nkgD]4g-`Ef V
tE"*!ot-*=@jI@DPv@IB̉T	bR-F^!TQPB`՚m@hh0cvNs|q:YypݢRDRv+@@
PLQj!zuZϯư(ԜaXwͥ*FRtSGL	܇f.roTtfFo`<T ˍc(q(&/8ێ6ۅV.ux<;we"U֜NpDpt!G^nc` P
97#fy@$ANk\w;J,^3r4OJv~-O&>c!4itnoSt!(8xCLIwm/TH0x
=H[l?[@tFKn\ήCؚ%S9QPHN(pU)JSN]P#buO:-) v'_qj'ĘM)8煹	h|O%z3>C `#g=7INrBӉJqCGreMEz1'
QN)8ө #\Hl 7!m0;Y⎺&r-֦M7lX&a&xTб9A&
H!w1*!c#	xN<5er
K97?FVZňwD?$*H!tҢ@?T낽} dE,˧J
IW]U>}{loOLfn5gu:
zvl33몫!	{XD-_fŚE^yp$TX2AP"rDNIϟ	9G./%R,vk>oMXh!
4@ķ::tL#dƤMYB`<`"ޅKxGƧB\ 
x,#yXq<emMEƶQP؈Sm P!`Ъ Y ItL9mjuz EE !6e`xn2f!ӿn(vRl~&
*^,ӟ?|g&	CY2ke8h]+KꝦ;xA[P9ez~TGQ
$
胷~>}
`KJ@;x aDl67(0p~ip>iAϓ/!w>k$| CbF`?^<=t:3
/.WӔgs L^DD(_K<	7>YLnj\X&aMJI C@ Ŵ
l*aOL
B+J=#B@"%,crB3++|	bC$@L T$n?!s~%EEQ((ȡ2B"R0gW+I͘2]LY c$ɫQG$p|9G/27rJXK'pzhb  >׆f S4!HG`BIH$()!cD&E'F3eKCHL8}ÉXʙ%KUw^!?_/W@;ör8+7CyI2Y92p.	*"ln`$-
sILv
,Q0(3cAA mrp |"q=%3)ʀ3,)2̧{@CMwΘ
Ͱ5|no7֝)B%/
Rb	@Is<Nl 76}x#Gga+]mv28v#bIP Xv"0K?&X6IRħ?Ƞ\L]h83:AqjDB!P@)/&u\*}r$cRtvHAs2CQ(:h``+\Y0s2K	!8A4n 6at{RHw!8D;MW:(,Fo%U@VcG		JWG̸/]^uR kQZ }V~l-0{w7U#([րp pA UiBp6x r<a5ۍ(Y[RӆJ
ٍm4 %Tm`a$,ufvgDAAG.xhL0H&kaD^h586afOc;Qf:;Vvla_-:i]OSMrjY,#'~0=r泱{̇-0ʝY:&-/gr\znxJPIpp& H!*9
	0mcI X
`Â[ )<Ahg ,2:Zfbl
Lq1@K!I+D$G#pFқ)!
;Aa@G;r">`n_4MæA;M"B!01ʇy}G>b=Z. jU+t@#(/ptG c6{,=O` Ez$h̋Fȏ9*t3PEI懡 
"N|nbސ/nqMqu#g8AdQ́~hED !I)UhY
m,:qGBV iO6[Kr|^Nn4KuvZ/M4}84V@nhZ >bO3G
"W!2 %qdf$Q2hL t0a}pK2p$;Ppg0Nin,U8_iH;P.2@"L=9XJV6i%4h2NklKZR%[ I{]'ygu,hܫH@ɂSb\mxtzk33am!QA<*dV$[4KnI;%/Z`Yc(AL`[[R`H
TF	H{!΂h;|@!O{xP+ |:؆I!Pi"V$E|eQ"UT ܊&sQDG$A@U<0\DȎ#sΉ*>L3
DDD"0D?s
9/"Hf&SLiL,[LLҨ5tK2DR4$B!	p P&i֨O7=O{*_!ϲr:~T۶˶߻3uQS7<qǻCpmG~o=xn==y	sTsw_#,+]1   ұ(	A`2Y<ؖK4@6bbC 3	ʼ"z:C(2@D]nm]%Ҙ
A,Ę2:Բp3`2D0[fɲ WQC*r-12JipPۀ*A/9HƤCF&Mmܗ00Mژo,|!?Lus,:g8֣\64uBP܆gBlрtoT!@Ù AZ	?{1㊋o<g<߫Evyˋz սYB-
	UfqDh-o*caVZT̮Fz!h,g`(%朴&gykeT)cή$f5 /M$
gH	 蓢4 3WТf,<&[~c^&wkܔMKY]|S_4/ӂGuib!1@c@po|σۯo>Ӭ6|ޅoa:"Dw:sRSIp:"V(cߜ|til|Ҥ+8(:D!GD3:My#3xXiڶ԰gtu'Q}Fi''qH܆,!TknfYmߥÃΜptG<~0``7Gt[ۇYxZ=̀d? `|ˏ3(	 fO(j^4k_qoZӂ5'9>x@AD	Sоn:s\;9amON<p%9#Їf3tׅobo֮]4T\@dҚ-?d4;KAE|U7W4D#FK(}C(""Bo
QSg(oK|R+9/u!UP*&'W0j5M0w"(.Юs]l[yprC۟mUYUUUHd
0ئwwJoaqݜG׬ͦ5ZРEXTlQ)$K<Z3f|XD؊#ƺBJE{
DD'򰎽?M	fߓ^R\sI<+1|(D2CAgYZ:
!^\z&Qq?)H}
Uk5\Tt$؇Os7gk>Tj:,~W{dz%>x,`ITYi2Y	#ň'H'-B(ǝx`o$;5d}gg}c"}~JPhdm&VULEh4~}{1-.!fDOT;k6^=5w
#ExkmM d=pϗi=GrbT6Ϧ'
.vu:Dnv<HXW=C6@0yK)fbM8l`$	dbAqgtUVX}q2T
I]/hEwA7<UQTn5`txhHp={Ϡ]<O6jۘRHMB#k4fU.WDrUvSZꮲSJVu\Z9t8E?!"eͣP"1栢Vl8CO2n'z'|,PsPd<\FݹV+np_[tn6Lc
+
Lj1+ug^)C;aTXL|k\UuJʚB*EAX\ar<Abi$3ϝ|=o{קJo|q鎴6t&#}.ɒ117) YAٵEpGduXk04R	-Tj
kl5ͩ	~
v@ϕ"sZ']nREel,`
Mlg)aJKJЈS9
IDCjdC)Y4T)^ٍceuwXe(OM" r NOtPhez=t6i
DX7`g)Uť³=l@&I-A+0QD UB:L@T4o\9(;UC	$Wt	`FA2~P
E)p&pJ|[T+)2 &ш)EE{&\c\(UB
B0 ~0Gf16#1ȎA  ,&oFp(Z
*L98,b:T苙#_[t~~HYc
	FQsN0;&({eh@JLN!q0a
g+f.*:X٧R䯢})	X!^{οyq礑5h31DA"h%d䯨)X0DP=܍l:)j	LJr,R$ShА@XHibJ =28@̃.} ';C)Z,A);*PьF~F XNw%v)=WtӇ-cma@cy]pgU~!mVi#gf%G˚t>5gxo<\QE
vDvFhfpSia
a/&ed1@|CmOn@dT؂-eihFybiSJB`Bܠ-iLFk)'4CZ)F*lVhɒȂRbAT2=J0JDζ;h%7 w4xi#7˲g`!32Wb6q+!S[I+jt'p
s00Vr̡I;*}-

D;q4<Ԡ_}  8Mӄ6@L92)d2kS@eHACAФpe% a}|$7'Yѳ_ Bz}e0TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTZ*Cd7,HBbttH`66Qtǂ6& ,|k	RR)55yUͳ)7qlR
~X'4z|R&HLHCn;(/H!e"IM`DSCiB*C-|?0Y`xh9"E|$4?~,@P2qe(OG0W09 vA8%X4aogХxN`[j"0XZ[
E,SE2
E_6*קL_%kbe1PwI0 Bo]n7^HzNJN!Ҋ`&ٳ.]-+/O遄ѧ*
/
!h@+@N'<R$/WX;GT+bLBܢTw(2Hzm'9FuD@Rǁ8Y
$EDOF~Aտ*J&Ƭ[Qjɪ*-D$	Z
HPy('߲~xrbBPd*8jt?@!/%=\> l 0J")5)j5CԨ@&6f}	@գ	)H=8\9{ކgX=7ء]	7!Aͭ{_>ScK"1݃R@
giYlIlG1WfAaϢUI/A0 Q)4S#)d5e,,D|Q4z`ra )}g%|iՅ@:SHnzP.BLR{dۺI[h?N3*	2BnnCY7OC
7Yȡݢ	i'.\P#Ƌu΅
u#aIv&JaOA}Ѳ|o?P@{Ԁ{@}  пb@ HHH%AAȎNd.EX>CєCaa=bC1Dڄǃu3U%D l؝(+mx_
!Q@|zlqlGG! i	*)B6D4Bw)4nZV@l.OC]W[]C)&)P, BS b ȂGQ:z<!@qp"ʃIn32w '(B G``vݖ&d0R! f	A*
E -
4?#4ĉfc ŨCb0ʷ7Qhڍe)w\5iDdԶ$he, !&
q8 G@hԀC5daC$9/W4Sss-ԡb$JdE. #	;Ez3՗؅Y"H
h}j:	.0"Sp'̾q9.?0z/Ԋ"!@-ñ<X@
AAE$J^	ZD;7J(|u=

rjOĄbC@LE~ÖwZI_8,VK48O)B$	OYw˵+3DE$FRTXLZG<(!ח[o_)~x>FltA8=O3ܘ i>F\vsߓOTwBsW2ď G%W>ưٛl'm!F'UQD=% H$(P<%MH BQx(nzCeB=[Xl1]'& m+i~i<8=+R#ۤ %̈́TFoBſ_±8\ah%mH2hw4*.#R2C@.6vE$!IN8~Lz`
N&;҈2#s$01:RAPl> $4TbLH}j"^`sKQB}dvP$N]S"J
Ve)(67F[%yݢv}|
]1Zb6I$!Ö:[c_?}G?_O?_/fM@Ɂ B$I4$KI2 U^܍J-2Fڋ4o;NCCID`2Bӣi4k4Dh:"f:kA	,1#
$\ pElLLV!L=6Gpeߦn03?"uР]B]jaɐ0%?!"@E`v@I!:dP0V-KYEQy4njKxlJwNIdRI$IT$a\XFRa jiS4YSA?J$~]5-K2EQmihjI&%IZIY
Q$fv(i|Oyrɲ_:Y2O`~8qiD*8{n)#d<?v%')>nYe<@II6#V`Î4-ɓH)
Nbd r$
1T h&s\7s! S#ƣHH^;bu>Y*A}*}ZИh8ɔӷf迶u<7Mlo0sw4	qعD`0phG\/:NQ	 nCM\m&2I	tAX{dʙ!J :ph.]}6=
^/OnUWZjb萠v;O
@@2C`^"d yIq&cIrRr8hy^KZ\>t
U!ÑIA&@b
`A)*=8ؾPhK:쎘3VѵjSԽۻO\û{!F7m&U(a"3iEJ3)FRe8X%)eLcmcح(F0'(
B;A)MFFfaC҆#ʄ̛ aR$@C52 oo0ҤPkRRAeYP1S䁲DB dvD46Et~?G`w? z1Ա2jl_0njk>3g)a4%,]y'1JG! ''~nڜ>$GfZ5=lDaۇqu4
Nh>Jt1WnVtvfB(49dxl@寽iAtK8$GN)\ڛ.U&=d6s
ã=S-"e/7ht]Ke	q@5н+YvI<L6%aA{lwÜ44@jv Hh18LoqRȨfmYuxaj [6RvSʾF xh]MɠPƠD8@a8*#
hv ox|O  r;\< p&Ʌ?PWNAl'y'x GS(@b% DF)kS!a
AhFIۖP0#m*08	~Pe?{:7K`lHXr2hY8/Z
8t͋Jy>${ψ"%|9rL$)Iei}^Gv0ۀ
׬vF#%4jbWH`iҝz1BJ5E10s΋z>nH}D4&Hћ74h,;\Ӵ7Ai^ɁnPp}Cq4K|kFC`eLYOH9j<j
`c OL<^2*7HC>P􂞨-%"qsׇ
F)L0=M0w6#h# )oCP<jnd>9H?tArbRbfhV$d?eG^ǫR	zIQl8 J+/V%pI(Dqa
rCZps::HaA̍,Lb"Droimjȅ
CU4Uיv}*$/_PAS1D239yԭ49-M,3M2!BleFҙ2$y]\3Ql,m
4($l)cKJX@.07r9S
COnFQuϦD6%ʤ !ΩJAsH
}4 <:A{<<a_%Dt
OR8O'46$Li[LCFEeTN0}?)@HT16LhF`l5,% 0S]$8g"$x
}iL|Em~.꜠jz][]Gy&a"Bcd㶜~Ɋ`LURx܆I]Lj 
u
mrlY93A0
)✦foLqI:۝Bes2-z
%@eC%Ig#&C4dDJjᔶӂ&LVo9fwPTB+8MmXӈHH%(+!J$A$E8:Z0L")Їr+pA5#d;KP3 BL
1HdjBu0B	Epi9 U`FH ;0@ w,[:WG)`0?Jڙ;O=zOy	D,d2>CNY3h5=NhsOpH;Evq}_߁1NLd("11F1uh1Vcw@HD~S܁߼>I? 	ӻ&JeS`&",p:<
j+r6LT3	d\Nau*baĞt5Z_ Vgp9h>v 	vqR*vΒԞQٰ]'V*dd@J*#O#4"7:zk">`3	QJ1wW<]#=e/_	$#d(ȟrwQ9ÑhŔZ7ܷ7&818`E̩  A㰦靟']|_n
4М8PlUD/x	Y6 U`c!s3iU
+R6zi	T,s0g$|-޸Bf4m!1Akmf ʆB-QhBJBҔӎ~)*,6n8^t'D^x2>S99Q$mg3);C@<ONC2[K
:ck3,p}F|GSh$'xr>T%wA=qoM(MH T->q .Z$6өW+FCBH?	^֪gAx<%4荀$%)0,\7PCl0atܥK&[Khv_Wn/opNje%!hKfL	Ii뻗v
TM-e
$EM9bdi%@Ia,4fSCw]
m(\6f(]a R˘7ba!3&	 S6Q	!#6Qq.[`hNH0˒A	I0 tҦei|!;ŽfD5A	fe*ݩCY(Ygcw
'\k&l	"cA=iP0@9Bh\(
mhf0
kИ7I#7rS s8S0ɁjI":Ca7ym0V㉁AsW*"2V %RRY) $EϷ_zrpyn-J!!|r\'%ܯy5Ź!Ovz{Ez 0'/984	
GߔƊf&Fp=vQ7+AJ}z\hP0Й	Hu](XSD.Xp
hk)Zv9iB1R䘇VЩ]djD73FenM@(lI
XM,sh4K2 P3YL$3bDiQ (Mrɦ"Yf&f]nfyaA@Dץ-Ȃh}?D$+KLU3 Pvh*"
v@"N?>">C|~3@LW(($
@&EdڔlQ6Q%SZfMD$`( |`dI hW̔I&fBlHUIrDb?8LQ J!!ŐDg$|1)Üzk@_i@IRpn`5	o͢L"xUS<<4m=SHd^fVؐ|~rWN R*!\gaTq%`5z<0aA  ^<󅑬l#2KEP.	16C"VD/X$q0Y?<Z5F:!EW{PP
"h!LDsM3l9jaY5vB(
D99#CHj
LD1cwr7nuW+uNIC$)Ƀ$)JrE9aHt"B"YSHKڤiSl.%K
NE[M2Bgt+&ge(aXA7C$9!DD? b1&!TS&aorE*!ޞc5a=BIG~l;
%H4NU5BnYϬ)Ea &B[fѿ[je
Rt_6xpN^Hr_e0--9jŏ w (?Aue(K=4a$ xy#+f@hp:btùf!|pLzA5R5/7hR\]a2QP49t㒶B:WJ.,5M4茻bmqLvd,^J3ZEQ4 %&ub0&()T8xm"LČQ$16]S ʪB8A2%Ӿ'L !W*%
#z?cԑGoOf
{B/ |_
J@! ia0C
*`! *l[~
jJ@jLLʫaUʹaBbE=f 4Pcb9T3
4!d!! m&JHfae$BD>Nژ0!@ܧ>($U
CI!:0wа	
Z(治! `4w$}|Hkz>w'> 91wz$)V7?!(( "B
QT+yG+)@R>L"	hI I 
JSBo6+A	Q2+!%LTUF7+gtꀢ yNajr2BQCtHS,ѻ
 oLWԨaβ`o@E-OĘP (uTP
TQP")Gc*9;dIR`*.& !G!#C>~gBR4 MB>F>c24p`h*4wttks$}f'YO:'"	WU hE>'
pr&{PIAQH\WwZywH\ZpNyAiA=;kkzpzL&#ȨӆbeNm
l4!
dN	k7gx(hgr zݒjrr=Н)W2b'	c| M: uyP3H,yw=/|;X(YTQ9@
G@:|/VUu'Dl`!ցG:h1
(x"%(![@?Qk)8,|>F,E'=!$}YI(xlaRy\&b')j( Xu}ؚ09"<.ar/oU@@:YC$ɀb~&i s<&Dљ{?*ִ; =
/,IejT<ޓI$02Yyֽ$C1qΆ@R^n{V[u]3;3 3D4e!vwN^ r!̚X'%)pИw!ίY-*nէIPT4ozLu6Q,hj$κ=ZJL;9<&
hrS`|Cm%(,}su438q>ShHI!$
+)t26#hBOa(Bh0!>n&N8qgty UAq0'B9Hފ:mJN8
e)g}
l+L(yu,
{GZ]y#Di}_ˑ̉l@nzt!j:@lAX^z	Wb&p0>Cy/.Z8C$gώ>YD&@ %;!pI(&eHW
dJ+H%!a^ 09u	
ihDlG1Í#[v(왎֞T9q<'l
6|gyBrh,!
t@魭̢B=8\+.~
'G׹D;vsU[/!d] %oI{
v v\$ޫ t-'ݠ5FyvynAZ< 6d6;6%E
8.%F@s-
0>C܃$`l; t-In~b<o/:a	t̅K1g`6k{Ͱ(iKo	@?( %i1-{c%BURo̟ԧB("#DӖs.e
""VM3`C:=qRxóIJ{G(7@zk4euwf?mA n!(h똥cZ\RS&!:&2($I
;>?|	 TH#$<YR՚C%ӗ(R*%(M7M8iG
fhD[˱`	(B	6]ư3{
)
,MjRU;2S1J	Ct5M`O:&1@(Jʲ/Q9aSNӘ͗J!XeNl"f`U,G($@6ӗ[F: H(MJhPh%1H
e%4BD;F KOy͆ ,ĨrCTB2	9-ple9)닦Zr#|Mጐ()[kCywhkT#d8K[2YF`a-u)ܕ]EEQƹ]wm]6Zu֕g;EjkyMrdwu,G{䲼뫺mHRVH %$
2:IP u%k2@7m 6`4Z!Yޜ<p|_7v 3!MJ|smb[-Q92e-a
7*Qt輇Ic,-%);Q%٦2*
lѡRoRl,^2I^ux-5%c
R°(\f@
>׮-l3ZÈtZu`m/]rCydʖ4zdZs7nOSX l	0HBܓ 	 ]YӨJK	 n$
0C՜`]FQhH`:eW1D _Yq	NHnh 'pH\`܈b$$) p0(tx>אLO&~<0_	;		LdPBd<ө|zP$LJ#v{Q?D4
ϟyXuE@@ (戆"9y
})"I}}vx>ٔԠЇt>8;!j%e ~CJs"myhժiI$UJe L0eR`3ptiG-&(eJHIVŸ`!Wնۓ-zCRhQG\ӂD!$
=Hv	1;6(m`l#*;h,,]^E
> "},n^^C
	MvE|	aL Lڿ4jTJ)K"@0aC**z1$~6z'z=$V9/J}sP4s?m 5`1s_yKx|z+o*&q&.Ra!ষ$5[KT!ig܃=>8ib@"v	*&
,̃Dz;1t1 d
bĹnzQ' DPCӆxl{Ow%Ѓ
P"FK|K>y'	oCN_'ȲMmA3&M^v^A
[rP2栟551!S /&ShY 	6"
4N4:p
䗝uuU3l%Fj*5c)J;	T2pdhQ$31Sg`ւ;)D@;yKE^.d@3*KD(& 5{	L@_p~Sv'%D1D1$BA0P!Dhg
$0P(/j `|u&J4C^eE{ XCC1A@ByP >*26CD"\GFXnK4I y0'zdRU4jPP%DGav%GRGD&ng%$ls%GB(:"TK`F.,D7%2mHXso//(y]ԙa60 BǸ:ZI)	y3Xt6P{3EA{rсBK!`ZjP6	~\dJERe ;av%!l!D..b~ˉw>}[j ^CE,zX;hiGXU.w)

aY`G^1{NziAvofi'J-NGsU{YcrL@i0aJ 6L#
im¹JEz>%bLT
56R!#!´njC65UzI0~<>=y[oϸ^%Q
Z/$tYGףYvddC<	b8yQT&.jXFU7amHU$µ kD:sb;g!0eY7/CoLa\5!iSu8Uk-QC ̨Fѩ0ݳT،Ϯ7-GmܰC\Df%UBԝkB DiGeNlcXBòLefyD4wgPvEJC u 'Wɉ" |"ጴ"ܓvudBQƸmt}>8ή+ONY,3:`{b㡮e}q}cF0[cQ1A#Qb)!Kd,=^y`P8  AnxO^Et=~x;u꧖FL٦ˈT|@*  ,F TE)D>TQ'FPs0K߄gW1YyjN${*nRaj^ 	!CoӠp("& Tq!TD3ȪH/afhtCxڻs_ q!M&`za'ҵ0H}}`hGD'qDe*vL00ў㱈Ba;G?x6`)e	cGD
O
4qCgp-"<S2D>$1ER Gly4 |+Ȋ&ø0Ko=
GBq`hP^ S쮚W<y§P=$@/4fkK,ĪTL5iu"
4AM0P!i\IaJC6\mJ&"rfymd'vf$m7X!:!B$?H~6b!ʻ<"' ,$-(!'q
B
(CsePZ`|$~,fR FL+~}J(&S:$=َ
\Dj_
SԘB;.&).!Aiؕ-(?Ӗ`g4dxaG{bbg%
S,Pv:S(<=(z^R$a+r@|:<UHHI+=Hyh1ω;ar;u@Au 4&ġCwc!O7!"Uъ)ߠGԁ=|/XW) mkbv*~ꔅ5(7tnWp(Š!$i9KH	$DQsXSRG
'G6>6)O?Bô{T
eA]d4h3cTU5-53QA=x|{-PwFAQWw|m}`v~ID%@vv1ʙ	3GGG^?8!<s1It4Q dF
hG>ACB
` drq"=XDhH
ʹ;[E&รU̜8&^uKB:JږJf 
%&ܨLh#LB)6H;s 8QN QmDE!WEF<6Ri(e/
x_^8@Pd" Ri]@(ħE\,:9#<p!]@<LjЋHBnlip4 RզYpd"-C<[Zݭ}Zuq/ l@vQ*<zckHkoฅr&ԁKb7Ng[@R!
 %  dpG\;6>`H=<IЦX|?@ݱI2f:h
+hi2;1 &hj=@B:Cz+<0Hhx"	ѦR4-т-8+3}21aWM乡do km+α2up,HYqf$8`KŷSĲa-3
],.n:ISKMEHilg,
l2m$ğK
zrB2-,2d2򓞙٦\冂$)fK@
)%
y8mF,0e/6^S!4Y+n>(ݭ&mnЄ(^{e21a<K -!*521 L|`l``5
T1'(Ҵσ$х|y¡gZ}5E%%8
lrMk@q!T@H;p7@ջQ
S*OC@!uL!$O1VԁB%p2|:Cqthv61Cg&]L
R)h`-xCx:xvA--[
Mpzw;0 tC 8 4Vw}QCΦ$Q#fY8;uv$4K0Y|a˳:^3)lܶ3(Ya!fCm3|bj^$mXNt!!c% hap:i4 1	2rbR@Mb)uqBxp7thG:;dmG,یBnD6CC&쬹cڂA1
J`	ob!!hXRBP&"p0	 v45IWn5u#E0]pB	JL*1! P(	0d(@uZmR;:ޯM9 :nj:2@X0jR:@+hCE		|~5	`Anwrg,;ni3SNTJhμRr)v@˲	-08%cH!K/<7^C8r{)4Ƚu"(4:mG	Fy}dt,(C\؊C2/ rm¨@99M݀K6Άu-cҙۜgtO)gK)glvF"oF#q.HZHR [۲0Y-* ]%GFD
l\dk<;Jl<%<?8^S	=[n45d2e=wiaJJ)s2ˢu8<8!n:h:Fڧ}([3FHv
!,{V:c%!WDkzsFǎf阂:K@6X=Hsu.5]X4
kBO]CfFn9+Z6AFJP/鶬i7oHHi_#A@
@k	
4B6	"qX kaBj^aro.\^k0{
9mۧlaЀᏎdy:ؚEAdV-/VD7ލGn,J7
 ڔzg>."6o E7
fJ@[*1ȋL΅؃_S3Wz$0qOLΜK_r.O>fڋ="n1́H ~֠ٚ+;|ȆDX-#
4һ
'<$!{&#C!q:G5x/%nAhMd 7h)2j@42
[.P4ZGQ)7\6ہQ0b
mG!|\%*
PSF#ZeC}(@;
UjMR`e3$0d2!Mr;
 璨&@NǲSXi .<Sn #T""D
B!'a]Q)X&QiAJhOfvTqUh
aI@[FdQY/_&BWiLdi7N8Fd8҃K@D#ۇ)m-8[AØ m aB2Ƅ7A	aD,
:A2
%MjG6bܲZAde& (X	ET^4<,uFpfUS߳gAd;5S4Q}
zfEPԨva(MCRCD{.u1d&([;T)܁paN8PJ2B"PBP`v,,4Y9C mBasL@_z=W+!Sh" <oT7.ʥrIG]RJw5S4IDۼ6b( s~D>c@CU2u7yN`eb/#17^fסSq<=qGJ
)nY8`HFbw▕v^4	UGXD"!py7}07y& GkrT96LvB>5(¸-'l(95zU$;"d+Ӌv̸+58]d&c;]&%IriK!F"ێMgî-]& $Єj24)CVq4$d,	`p8	:"#e0(vUUU]>aA$O:6"1(xvd`_6 b
PVԄq$2(hL43_cz((<A1.dZ:#sGb%P>`	]v! M[sH	z ǸDI
I9z=aީJ2@HH1zd^!wBy0hP%
(
S@jXmYNBr(<NY>!>?@ԇLaPñ@K*P"JЄG=jyϧڝᆃQa45~ÊUM
xE* @=1t1Sr 1V]>r9( AҚ0y4"iF.9J[vO|`F$<Hb H! xn&tLϢqwî(9S4!:TnxٱT8 [4ZRӮ4`ý
hQ(Wìqm3/	0p6Xyν
p݄]2H	"@!qH;}~APuGapt D{'+fB-AMd)
0b lP0p6ANrb%QA/
Bt	@ Xmfʒ[t*Y$C(!z?`}O@ snH#GCBҀzLY"{CiQA")zz>.C"
}mm\f')hRɰF%YO>?M )4 k10 Xm5rVW4tFB8wJ.<'̉tP]DI$GOY:ςWxw8
_7"A}!@DĕSDaBCJ(P$%(PJDQ(Z$8h(ؿD=h?a#՟d.4!Ih
VT@@~L
*5!~'{\S_a7x·2݃] ѣNZ̤"WuחTto)u5^Hj,lD&
Z`9f a+PB>)0$0l/(m%dVp/CH63"դx)'NVƆF r/^h`H	Ncxmq$F'CrNR`<(OĔz2!mc*?VF"2D!ԤQ -6TBoX hY1"RQIQ>c4OKGH?$߹+\rh݃p/zw;R[Ӿ0~0P? DIr	Hӆ̙!b&6h2(w0鬋ܭ˻r2T!b  XXO}`MD0iTQ	HZKϝrh,fѶF+R=҃Hvnۀ@$A	IPOz47${9ZNRr#YF.`~4I
b"
p1HSH/:9IV0 JCdlVJRZH .R%AR	DUHHaR;} JA/ƨUr
cDd=@x*rS'i8HFEyPxccy-)pP8~y҅%=eDrMʀ`w+UG!p+bbCVAI5zr9D-=ўDeL1(H#aII
BB.	8
hrᤳ6{cA S08&i- i1B]qe
Hx*vUm̧+Xa"UFDxKC*bH
,HHP?=9iOE+`IhƁ,IAT`/+Aw={VXBF.ԕ0ҮCU	DRQa@J#$BE
D˵1WV8~+فD,D,"`bL">8R2*"'πt6Pı-p= V\<
ЅT	IH(P@40v;~ =89s6=':'Jh
|ԅA#PS
7Υ2%nv2n}DI$bH$$'y$Ϗ]"$C)"<-<A}gԯ;1;;2s  vI!MJ=-y!5=ى6̩i-l\DDb% o
 %S44k"ʹdI!f2(ePC&T(3XLɪ?G~x[fS 4*eak3,3N-h)M#ƶ5-4Cw 6lƇAF*]v>@ DⅳABL!ͭ@wWI$!{C>69/
T P qNhI{9.xQvGBTzk:x!Q-Tb͕N!8J( DGk&)m
jyU7)'p{ÐE'Fp7j/A{C?7ËUWʂavAy1Jbf	S03(ۢB0xa`R]K#q$hz6B1έ!1LŒN9{=r0K$c@"v[.J./r2|*<( 	WRyFEmha"
7%ZPemW,0 qQ8P<Klnᒫ۩@ꀆ$
+!	֯	Ċp P
@ hCbH
aA#1Q\dfEWA
	 "J3b*0e,D<c:-*l) (* 6EM/i
bO@G"HBYM>#GA`iep7;zM6|7JPcDdH0m4rHX3uF;aIricOIƀD띻v퍤fbИZZB	Ekko<!ӎbh}Ӷu(6CIKtӒ3GSR)r*ٶ@M
F8CK4j*D3jʺӴZ2?"D,m!PuEsul`p DIP;?߰B>8SSx?AD:g2eDjX(u&ؐ5_mZL*74)
AU= <C)WdǵlO	8T>RഉCL%EPBEʫ&d4V[,BUCEQz0L~JLD("*3cE5c,M%lI(Wж"N!IhH :AQCC݃	@qSjeUXm	ƶ%!vM&)!hL $=bi~/49W_ꈽCp!z U)TR	ͤ4+Jhʁ@(o)dC52vAfؙ BtecrILu.呅Iv3P<9dCE4fksvTDr==SZmQ;Fg[||ΣvZzTMƽIW^|?li|ٿ<EENyۨl]]XUuGy^T|uIC^:ό7^Džj`yrۿ:J|y".ݝ1񍣜o>:φ\L)θoCy83=ҳExc^[rb{<g~כk_Op]^:֧Ϗh5]W6uُU3y^D/|g{K;	~~ڛ}ug.1㏮+Z#}]tU!W~x_y|=o9ix;_]O~	A#>Ou	&:ͪe:oSNy7s~og{P{x[ߑ5E{wuZ7ە
v͝\
=ĝ6:^?Wwm\~9p<k۾_<Ãx͋e|m=wS7\o,w)g̟cQ^CT]Z}ow=ۯcK~ws|+sϓ#}yrLO<[ﯜx]]<sNǾTўKuׇl^WggOo:Ϛچu_7Vԥ7!׬|nsyvq/d+]Hubz^^aWQ]w{ί3~y;rGs׻[:G{#250o:'bJG7I:ιË/Uwykcv=y]O׿9^s6:w[7ߢ3˛o=w|a6wrǴfz~ϛ |:!|>{ߦ=yvu:^bh`//uOY}x]8ߞw˿S߽@Qm-Yr7qQ]7__7MN#k~}Cwxyg;:x\O70ڷY~xw;9>3cs})7m^/ަd|w]>ny>~>e>Cyuz
l[V^G/΋G}Ho
Y魾7{W9l9nZu..#ogΕj^8GCj  qU` 4|&a{& Pf'
Qe)