#!/bin/bash

A336_input=( Tuner )
H830_input=( Tuner Composite S-Video )
C039_input=( Composite S-Video )

### select model ###
PS3="Capture card model: "

select s_model in A336 H830 C039 quit
do
	[ "$s_model" = "quit" ] && exit 0
	break
done
echo ""



### select standard ###
PS3="Setting color standard as: "
select s_standard in NTSC PAL SECAM
do
	case $s_standard in
	PAL)	std=6
		height=576
		freq=147.25
		;;
	SECAM)	std=15
		height=576
		freq=140.25
		;;
	*)	std=0
		height=480
		freq=409.25
		;;
	esac	
	break
done
echo ""


### select standard ###
PS3="Select input for $s_model: "
case $s_model in
A336)
	select s_input in ${A336_input[*]}
	do
		break
	done ;;
H830)
	select s_input in ${H830_input[*]}
	do
		break
	done ;;

C039)
	select s_input in ${C039_input[*]}
	do
		break
	done ;;
*)
	echo unknown model
	exit ;;
esac

[ "$s_input" = "" ] && echo "Error input" && exit 0

input=`expr $REPLY - 1`
echo ""

#echo "std=$std, input=$input"

### command ###
case $s_input in
Tuner)
	mplayer -quiet -slave tv:// -tv driver=v4l2:device=/dev/video0:alsa:adevice=hw.1,0:amode=1:audiorate=48000:forceaudio:volume=100:immediatemode=0:normid=$std:outfmt=YUY2:input=$input:freq=$freq:buffersize=64:height=$height:width=720
	;;
*)
	mplayer -quiet -slave tv:// -tv driver=v4l2:device=/dev/video0:alsa:adevice=hw.1,0:amode=1:audiorate=48000:forceaudio:volume=100:immediatemode=0:normid=$std:outfmt=YUY2:input=$input:buffersize=64:height=$height:width=720
	;;
esac	
