/* ========================================================================== */
/*                                                                            */
/*   vlc_query.c                                                              */
/*   (c) 2011 Author MPDII AverMedia                                                          */
/*                                                                            */
/*   Description                                                              */
/*                                                                            */
/*                                                                            */
/*   To compile: gcc -Wall -o dvb_query dvb_query.c                           */
/* ========================================================================== */

#include <unistd.h>
#include <string.h>
#include <sys/mman.h>
#include <asm/types.h>

#include <stdlib.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <linux/dvb/dmx.h>
#include <linux/dvb/frontend.h>

/*
 * In	: fd - open to check
 * Out	: none
 */
static void check_device(int fd)
{
  int err;
	struct dvb_frontend_info info;
	char buffer[128];
  
  memset(buffer, 0, sizeof(buffer));
  
  err = ioctl(fd, FE_GET_INFO, &info);
  
  if( err ) // query frontend error 
  {
    printf("query frontend error\n");
    return;
  }
  else
  {
    memcpy(buffer, &(info.name), sizeof(buffer));
    printf("name-->%s\n", buffer);
    switch(info.type)
    {
      case FE_QPSK:
        printf("type-->FE_QPSK  DVB-S\n");
      break;
      case FE_QAM:
        printf("type-->FE_QAM   DVB-C\n");
      break;
      case FE_OFDM:
        printf("type-->FE_QFDM  DVB-T\n");
      break;
      case FE_ATSC:
        printf("type-->FE_ATSC  ATSC\n");
      break;
      default:
        printf("type-->others   others\n");
      break;
    }
  }
  return;
}

int main(int argc, char *argv[])
{
  int fd;
  char *filename;
  
  filename = argv[1];
  fd = open(filename, O_RDONLY);
  if( fd<0 ) 
  {
    perror(filename);
    exit(1);
  } 
  check_device(fd);
  close(fd);
  
  return 0;
}
