#!/bin/bash

# Copyright (C) Guangzhou FriendlyARM Computer Tech. Co., Ltd.
# (http://www.friendlyarm.com)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, you can access it online at
# http://www.gnu.org/licenses/gpl-2.0.html.

# Automatically re-run script under sudo if not root
if [ $(id -u) -ne 0 ]; then
	echo "Re-running script under sudo..."
	sudo "$0" "$@"
	exit
fi

# ----------------------------------------------------------
# Checking device for fusing

if [ -z $1 ]; then
	echo "Usage: $0 DEVICE"
	exit 0
fi

case $1 in
/dev/sd[a-z] | /dev/loop[0-9] | /dev/mmcblk1)
	if [ ! -e $1 ]; then
		echo "Error: $1 does not exist."
		exit 1
	fi
	DEV_NAME=`basename $1`
	BLOCK_CNT=`cat /sys/block/${DEV_NAME}/size` ;;&
/dev/sd[a-z])
	DEV_PART=${DEV_NAME}2
	REMOVABLE=`cat /sys/block/${DEV_NAME}/removable` ;;
/dev/mmcblk1 | /dev/loop[0-9])
	DEV_PART=${DEV_NAME}p2
	REMOVABLE=1 ;;
*)
	echo "Error: Unsupported SD reader"
	exit 0
esac

if [ ${REMOVABLE} -le 0 ]; then
	echo "Error: $1 is non-removable device. Stop."
	exit 1
fi

if [ -z ${BLOCK_CNT} -o ${BLOCK_CNT} -le 0 ]; then
	echo "Error: $1 is inaccessible. Stop fusing now!"
	exit 1
fi

let DEV_SIZE=${BLOCK_CNT}/2
if [ ${DEV_SIZE} -gt 64000000 ]; then
	echo "Error: $1 size (${DEV_SIZE} KB) is too large"
	exit 1
fi

if [ ${DEV_SIZE} -le 3800000 ]; then
	echo "Error: $1 size (${DEV_SIZE} KB) is too small"
	echo "       At least 4GB SDHC card is required, please try another card."
	exit 1
fi

# ----------------------------------------------------------
# Get host machine
if grep 'ARMv7 Processor' /proc/cpuinfo >/dev/null; then
#	EMMC=.emmc
	ARCH=armv7/
fi

# ----------------------------------------------------------
# Fusing bootloader to SD card

BL_BIN=k2uboot.bin
BL_POSITION=1

if [ ! -f ${BL_BIN} ]; then
	echo "Error: ${BL_BIN}: file not found"
	exit -1
fi

echo "/dev/$DEV_NAME"
#exit 0

# umount all at first
#umount /dev/${DEV_NAME}* > /dev/null 2>&1

echo "---------------------------------"
echo "bootloader fusing"
dd if=${BL_BIN} of=/dev/${DEV_NAME} conv=fsync bs=1 count=442
echo "Step one complete, waiting for part 2"
sleep 3
dd if=${BL_BIN} of=/dev/${DEV_NAME} conv=fsync bs=512 skip=1 seek=1
sync

#<Message Display>
echo "---------------------------------"
echo "Bootloader image is fused successfully."
echo ""

