#!/bin/sh

# Global Variables
SSID="serendrewpity"
SECRET="BoogerAids"
SLEEP_TIME=3  # Time to pause between retries (in seconds)
LOGFILE="/storage/.config/autostart.log"

# Truncate the log file at the beginning of the script
> "$LOGFILE"

# Logging function to prepend timestamp to each log entry
log() {
	while IFS= read -r line; do
		echo "$(date '+%a %b %-d %H:%M:%S %Z %Y') - $line" >> "$LOGFILE"
	done
}

# Redirect stdout and stderr to the log function
exec > >(log) 2>&1

# Start Processing of AutoStart script.
echo "AutoStart script is starting."

# Start Processing of AutoStart script.
echo "Stopping the default ConnMan and Internet Wireless Daemon services."
systemctl stop connman 
systemctl stop iwd
kill -9 $(pgrep connmand) $(pgrep iwd)

# Starting IWD.
echo "Starting the Internet Wireless Daemon service."
nohup /usr/lib/iwd --debug > /storage/.config/iwd_debug.log 2>&1 & 
sleep 2

# Starting ConnMan.
echo "Starting the ConnMan daemon service."
nohup /usr/sbin/connmand --debug > /storage/.config/connman_debug.log 2>&1 &
sleep 2

# Perform an initial scan
echo "Scanning for Wifi Networks."
iwctl station wlan0 scan
connmanctl scan wifi

# Attempt to connect to Wifi on wlan0
echo "Attempting to connect to Wifi SSID on wlan0."
ERROR=$(/usr/bin/iwctl station wlan0 connect $SSID --passphrase=$SECRET 2>&1)
timeout=$(($(date +%s) + 25))
until [ -n "$(ip -4 route get 8.8.8.8 2>/dev/null | awk {'print $7'} | tr -d '\n')" ] || [ $(date +%s) -gt $timeout ]; do sleep $SLEEP_TIME; done
journalctl | grep -E 'iwd\[|connmand\['

# AutoStart script finished.
echo "AutoStart script finished."