# vim: set et sw=4 sts=4 fileencoding=utf-8:
#
# The colorzero color library
#
# Copyright (c) 2016-2018 Dave Jones <dave@waveform.org.uk>
#
# SPDX-License-Identifier: BSD-3-Clause

"""
Defines the available color names, derived from the `CSS Color Module`_ Level 3
Specification, section 4.3, along with tables for the original DOS colors, and
XTerm colors (for :func:`format` output).

.. _CSS Color Module: http://www.w3.org/TR/css3-color/#svg-color
"""

# I like my spacing, dammit!
# pylint: disable=bad-whitespace,bad-continuation


def _transpose(table):
    # Swap keys and values in a dict, but in the case of duplicated keys, use
    # the first encountered instead of the last
    result = {}
    for k, v in table.items():
        result.setdefault(v, k)
    return result


DOS_COLORS = _transpose({
#    Bold,  Index: (R,   G,   B),
    (False, 0):    (0,   0,   0),
    (False, 1):    (128, 0,   0),
    (False, 2):    (0,   128, 0),
    (False, 3):    (128, 128, 0),
    (False, 4):    (0,   0,   128),
    (False, 5):    (128, 0,   128),
    (False, 6):    (0,   128, 128),
    (False, 7):    (192, 192, 192),
    (True,  0):    (128, 128, 128),
    (True,  1):    (255, 0,   0),
    (True,  2):    (0,   255, 0),
    (True,  3):    (255, 255, 0),
    (True,  4):    (0,   0,   255),
    (True,  5):    (255, 0,   255),
    (True,  6):    (0,   255, 255),
    (True,  7):    (255, 255, 255),
})


XTERM_COLORS = _transpose({
# Index: (R,   G,   B)
    0:   (0,   0,   0),
    1:   (128, 0,   0),
    2:   (0,   128, 0),
    3:   (128, 128, 0),
    4:   (0,   0,   128),
    5:   (128, 0,   128),
    6:   (0,   128, 128),
    7:   (192, 192, 192),
    8:   (128, 128, 128),
    9:   (255, 0,   0),
    10:  (0,   255, 0),
    11:  (255, 255, 0),
    12:  (0,   0,   255),
    13:  (255, 0,   255),
    14:  (0,   255, 255),
    15:  (255, 255, 255),
    16:  (0,   0,   0),
    17:  (0,   0,   95),
    18:  (0,   0,   135),
    19:  (0,   0,   175),
    20:  (0,   0,   215),
    21:  (0,   0,   255),
    22:  (0,   95,  0),
    23:  (0,   95,  95),
    24:  (0,   95,  135),
    25:  (0,   95,  175),
    26:  (0,   95,  215),
    27:  (0,   95,  255),
    28:  (0,   135, 0),
    29:  (0,   135, 95),
    30:  (0,   135, 135),
    31:  (0,   135, 175),
    32:  (0,   135, 215),
    33:  (0,   135, 255),
    34:  (0,   175, 0),
    35:  (0,   175, 95),
    36:  (0,   175, 135),
    37:  (0,   175, 175),
    38:  (0,   175, 215),
    39:  (0,   175, 255),
    40:  (0,   215, 0),
    41:  (0,   215, 95),
    42:  (0,   215, 135),
    43:  (0,   215, 175),
    44:  (0,   215, 215),
    45:  (0,   215, 255),
    46:  (0,   255, 0),
    47:  (0,   255, 95),
    48:  (0,   255, 135),
    49:  (0,   255, 175),
    50:  (0,   255, 215),
    51:  (0,   255, 255),
    52:  (95,  0,   0),
    53:  (95,  0,   95),
    54:  (95,  0,   135),
    55:  (95,  0,   175),
    56:  (95,  0,   215),
    57:  (95,  0,   255),
    58:  (95,  95,  0),
    59:  (95,  95,  95),
    60:  (95,  95,  135),
    61:  (95,  95,  175),
    62:  (95,  95,  215),
    63:  (95,  95,  255),
    64:  (95,  135, 0),
    65:  (95,  135, 95),
    66:  (95,  135, 135),
    67:  (95,  135, 175),
    68:  (95,  135, 215),
    69:  (95,  135, 255),
    70:  (95,  175, 0),
    71:  (95,  175, 95),
    72:  (95,  175, 135),
    73:  (95,  175, 175),
    74:  (95,  175, 215),
    75:  (95,  175, 255),
    76:  (95,  215, 0),
    77:  (95,  215, 95),
    78:  (95,  215, 135),
    79:  (95,  215, 175),
    80:  (95,  215, 215),
    81:  (95,  215, 255),
    82:  (95,  255, 0),
    83:  (95,  255, 95),
    84:  (95,  255, 135),
    85:  (95,  255, 175),
    86:  (95,  255, 215),
    87:  (95,  255, 255),
    88:  (135, 0,   0),
    89:  (135, 0,   95),
    90:  (135, 0,   135),
    91:  (135, 0,   175),
    92:  (135, 0,   215),
    93:  (135, 0,   255),
    94:  (135, 95,  0),
    95:  (135, 95,  95),
    96:  (135, 95,  135),
    97:  (135, 95,  175),
    98:  (135, 95,  215),
    99:  (135, 95,  255),
    100: (135, 135, 0),
    101: (135, 135, 95),
    102: (135, 135, 135),
    103: (135, 135, 175),
    104: (135, 135, 215),
    105: (135, 135, 255),
    106: (135, 175, 0),
    107: (135, 175, 95),
    108: (135, 175, 135),
    109: (135, 175, 175),
    110: (135, 175, 215),
    111: (135, 175, 255),
    112: (135, 215, 0),
    113: (135, 215, 95),
    114: (135, 215, 135),
    115: (135, 215, 175),
    116: (135, 215, 215),
    117: (135, 215, 255),
    118: (135, 255, 0),
    119: (135, 255, 95),
    120: (135, 255, 135),
    121: (135, 255, 175),
    122: (135, 255, 215),
    123: (135, 255, 255),
    124: (175, 0,   0),
    125: (175, 0,   95),
    126: (175, 0,   135),
    127: (175, 0,   175),
    128: (175, 0,   215),
    129: (175, 0,   255),
    130: (175, 95,  0),
    131: (175, 95,  95),
    132: (175, 95,  135),
    133: (175, 95,  175),
    134: (175, 95,  215),
    135: (175, 95,  255),
    136: (175, 135, 0),
    137: (175, 135, 95),
    138: (175, 135, 135),
    139: (175, 135, 175),
    140: (175, 135, 215),
    141: (175, 135, 255),
    142: (175, 175, 0),
    143: (175, 175, 95),
    144: (175, 175, 135),
    145: (175, 175, 175),
    146: (175, 175, 215),
    147: (175, 175, 255),
    148: (175, 215, 0),
    149: (175, 215, 95),
    150: (175, 215, 135),
    151: (175, 215, 175),
    152: (175, 215, 215),
    153: (175, 215, 255),
    154: (175, 255, 0),
    155: (175, 255, 95),
    156: (175, 255, 135),
    157: (175, 255, 175),
    158: (175, 255, 215),
    159: (175, 255, 255),
    160: (215, 0,   0),
    161: (215, 0,   95),
    162: (215, 0,   135),
    163: (215, 0,   175),
    164: (215, 0,   215),
    165: (215, 0,   255),
    166: (215, 95,  0),
    167: (215, 95,  95),
    168: (215, 95,  135),
    169: (215, 95,  175),
    170: (215, 95,  215),
    171: (215, 95,  255),
    172: (215, 135, 0),
    173: (215, 135, 95),
    174: (215, 135, 135),
    175: (215, 135, 175),
    176: (215, 135, 215),
    177: (215, 135, 255),
    178: (215, 175, 0),
    179: (215, 175, 95),
    180: (215, 175, 135),
    181: (215, 175, 175),
    182: (215, 175, 215),
    183: (215, 175, 255),
    184: (215, 215, 0),
    185: (215, 215, 95),
    186: (215, 215, 135),
    187: (215, 215, 175),
    188: (215, 215, 215),
    189: (215, 215, 255),
    190: (215, 255, 0),
    191: (215, 255, 95),
    192: (215, 255, 135),
    193: (215, 255, 175),
    194: (215, 255, 215),
    195: (215, 255, 255),
    196: (255, 0,   0),
    197: (255, 0,   95),
    198: (255, 0,   135),
    199: (255, 0,   175),
    200: (255, 0,   215),
    201: (255, 0,   255),
    202: (255, 95,  0),
    203: (255, 95,  95),
    204: (255, 95,  135),
    205: (255, 95,  175),
    206: (255, 95,  215),
    207: (255, 95,  255),
    208: (255, 135, 0),
    209: (255, 135, 95),
    210: (255, 135, 135),
    211: (255, 135, 175),
    212: (255, 135, 215),
    213: (255, 135, 255),
    214: (255, 175, 0),
    215: (255, 175, 95),
    216: (255, 175, 135),
    217: (255, 175, 175),
    218: (255, 175, 215),
    219: (255, 175, 255),
    220: (255, 215, 0),
    221: (255, 215, 95),
    222: (255, 215, 135),
    223: (255, 215, 175),
    224: (255, 215, 215),
    225: (255, 215, 255),
    226: (255, 255, 0),
    227: (255, 255, 95),
    228: (255, 255, 135),
    229: (255, 255, 175),
    230: (255, 255, 215),
    231: (255, 255, 255),
    232: (8,   8,   8),
    233: (18,  18,  18),
    234: (28,  28,  28),
    235: (38,  38,  38),
    236: (48,  48,  48),
    237: (58,  58,  58),
    238: (68,  68,  68),
    239: (78,  78,  78),
    240: (88,  88,  88),
    241: (98,  98,  98),
    242: (108, 108, 108),
    243: (118, 118, 118),
    244: (128, 128, 128),
    245: (138, 138, 138),
    246: (148, 148, 148),
    247: (158, 158, 158),
    248: (168, 168, 168),
    249: (178, 178, 178),
    250: (188, 188, 188),
    251: (198, 198, 198),
    252: (208, 208, 208),
    253: (218, 218, 218),
    254: (228, 228, 228),
    255: (238, 238, 238),
})


NAMED_COLORS = {
    'aliceblue':             '#f0f8ff',
    'antiquewhite':          '#faebd7',
    'aqua':                  '#00ffff',
    'aquamarine':            '#7fffd4',
    'azure':                 '#f0ffff',
    'beige':                 '#f5f5dc',
    'bisque':                '#ffe4c4',
    'black':                 '#000000',
    'blanchedalmond':        '#ffebcd',
    'blue':                  '#0000ff',
    'blueviolet':            '#8a2be2',
    'brown':                 '#a52a2a',
    'burlywood':             '#deb887',
    'cadetblue':             '#5f9ea0',
    'chartreuse':            '#7fff00',
    'chocolate':             '#d2691e',
    'coral':                 '#ff7f50',
    'cornflowerblue':        '#6495ed',
    'cornsilk':              '#fff8dc',
    'crimson':               '#dc143c',
    'cyan':                  '#00ffff',
    'darkblue':              '#00008b',
    'darkcyan':              '#008b8b',
    'darkgoldenrod':         '#b8860b',
    'darkgray':              '#a9a9a9',
    'darkgreen':             '#006400',
    'darkgrey':              '#a9a9a9',
    'darkkhaki':             '#bdb76b',
    'darkmagenta':           '#8b008b',
    'darkolivegreen':        '#556b2f',
    'darkorange':            '#ff8c00',
    'darkorchid':            '#9932cc',
    'darkred':               '#8b0000',
    'darksalmon':            '#e9967a',
    'darkseagreen':          '#8fbc8f',
    'darkslateblue':         '#483d8b',
    'darkslategray':         '#2f4f4f',
    'darkslategrey':         '#2f4f4f',
    'darkturquoise':         '#00ced1',
    'darkviolet':            '#9400d3',
    'deeppink':              '#ff1493',
    'deepskyblue':           '#00bfff',
    'dimgray':               '#696969',
    'dimgrey':               '#696969',
    'dodgerblue':            '#1e90ff',
    'firebrick':             '#b22222',
    'floralwhite':           '#fffaf0',
    'forestgreen':           '#228b22',
    'fuchsia':               '#ff00ff',
    'gainsboro':             '#dcdcdc',
    'ghostwhite':            '#f8f8ff',
    'gold':                  '#ffd700',
    'goldenrod':             '#daa520',
    'gray':                  '#808080',
    'green':                 '#008000',
    'greenyellow':           '#adff2f',
    'grey':                  '#808080',
    'honeydew':              '#f0fff0',
    'hotpink':               '#ff69b4',
    'indianred':             '#cd5c5c',
    'indigo':                '#4b0082',
    'ivory':                 '#fffff0',
    'khaki':                 '#f0e68c',
    'lavender':              '#e6e6fa',
    'lavenderblush':         '#fff0f5',
    'lawngreen':             '#7cfc00',
    'lemonchiffon':          '#fffacd',
    'lightblue':             '#add8e6',
    'lightcoral':            '#f08080',
    'lightcyan':             '#e0ffff',
    'lightgoldenrodyellow':  '#fafad2',
    'lightgray':             '#d3d3d3',
    'lightgreen':            '#90ee90',
    'lightgrey':             '#d3d3d3',
    'lightpink':             '#ffb6c1',
    'lightsalmon':           '#ffa07a',
    'lightseagreen':         '#20b2aa',
    'lightskyblue':          '#87cefa',
    'lightslategray':        '#778899',
    'lightslategrey':        '#778899',
    'lightsteelblue':        '#b0c4de',
    'lightyellow':           '#ffffe0',
    'lime':                  '#00ff00',
    'limegreen':             '#32cd32',
    'linen':                 '#faf0e6',
    'magenta':               '#ff00ff',
    'maroon':                '#800000',
    'mediumaquamarine':      '#66cdaa',
    'mediumblue':            '#0000cd',
    'mediumorchid':          '#ba55d3',
    'mediumpurple':          '#9370db',
    'mediumseagreen':        '#3cb371',
    'mediumslateblue':       '#7b68ee',
    'mediumspringgreen':     '#00fa9a',
    'mediumturquoise':       '#48d1cc',
    'mediumvioletred':       '#c71585',
    'midnightblue':          '#191970',
    'mintcream':             '#f5fffa',
    'mistyrose':             '#ffe4e1',
    'moccasin':              '#ffe4b5',
    'navajowhite':           '#ffdead',
    'navy':                  '#000080',
    'oldlace':               '#fdf5e6',
    'olive':                 '#808000',
    'olivedrab':             '#6b8e23',
    'orange':                '#ffa500',
    'orangered':             '#ff4500',
    'orchid':                '#da70d6',
    'palegoldenrod':         '#eee8aa',
    'palegreen':             '#98fb98',
    'paleturquoise':         '#afeeee',
    'palevioletred':         '#db7093',
    'papayawhip':            '#ffefd5',
    'peachpuff':             '#ffdab9',
    'peru':                  '#cd853f',
    'pink':                  '#ffc0cb',
    'plum':                  '#dda0dd',
    'powderblue':            '#b0e0e6',
    'purple':                '#800080',
    'red':                   '#ff0000',
    'rosybrown':             '#bc8f8f',
    'royalblue':             '#4169e1',
    'saddlebrown':           '#8b4513',
    'salmon':                '#fa8072',
    'sandybrown':            '#f4a460',
    'seagreen':              '#2e8b57',
    'seashell':              '#fff5ee',
    'sienna':                '#a0522d',
    'silver':                '#c0c0c0',
    'skyblue':               '#87ceeb',
    'slateblue':             '#6a5acd',
    'slategray':             '#708090',
    'slategrey':             '#708090',
    'snow':                  '#fffafa',
    'springgreen':           '#00ff7f',
    'steelblue':             '#4682b4',
    'tan':                   '#d2b48c',
    'teal':                  '#008080',
    'thistle':               '#d8bfd8',
    'tomato':                '#ff6347',
    'turquoise':             '#40e0d0',
    'violet':                '#ee82ee',
    'wheat':                 '#f5deb3',
    'white':                 '#ffffff',
    'whitesmoke':            '#f5f5f5',
    'yellow':                '#ffff00',
    'yellowgreen':           '#9acd32',
}
