#
#Read in the rating labels definitions file and look for those
#matching the specified country code.
#
#Return an array with all of the matching labels.
#
#Copyright (c) DeltaMikeCharlie 2024
#
#import xbmc

def findLabels(country, dataPath, iconPath):

	foundLabels = []

	try:
		file = open(dataPath + "ratinglabels.txt","r")
	except:
		file = None
	if file:
		while True:
			thisLine = file.readline()
			if not thisLine:
				break
			if thisLine[0] != "#":
				thisLine = thisLine.rstrip()  #Strip trailing CR/LF characters
				fields = thisLine.split("\t")
				#xbmc.log("  FIELDS " + str(len(fields)) + " " + str(fields), level=xbmc.LOGINFO)
				if len(fields) == 7:
					if fields[0] == country:
						thisRating = {}
						thisRating['enabled'] = True
						thisRating['country'] = fields[0]
						thisRating['age'] = fields[1]
						thisRating['display_age'] = fields[2]
						thisRating['display_label'] = fields[3]
						thisRating['label'] = fields[4]
						thisRating['authority'] = fields[5]
						thisRating['icon'] = ""
						if fields[6] == "<NONE>":
							fields[6] = ""
						if len(fields[6]) != 0:
							thisRating['icon'] = iconPath + fields[6]
						foundLabels.append(thisRating)
		file.close()

	return foundLabels